/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.utils.ParamsUtils;
import cn.tenmg.dsl.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PlaceHolderUtils {
    private static final Pattern paramPattern = Pattern.compile("\\$\\{[^}]+\\}");
    private static final HashSet<Character> ENCODE_CHARACTERS = new HashSet<Character>(){
        private static final long serialVersionUID = -1974796098018071303L;
        {
            this.add(Character.valueOf('$'));
        }
    };

    public static String replace(String tpl, CharSequence ... params) {
        if (params != null && params.length > 1) {
            HashMap<CharSequence, CharSequence> map = new HashMap<CharSequence, CharSequence>();
            for (int i = 0; i < params.length; i += 2) {
                map.put(params[i], params[i + 1]);
            }
            return PlaceHolderUtils.replace(tpl, map);
        }
        return tpl;
    }

    public static String replace(String tpl, Map<?, ?> params) {
        if (StringUtils.isBlank((String)tpl)) {
            return tpl;
        }
        if (params == null || params.isEmpty()) {
            return tpl;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = paramPattern.matcher(tpl);
        boolean encode = false;
        while (m.find()) {
            String name = m.group();
            Object value = ParamsUtils.getParam(params, (String)name.substring(2, name.length() - 1));
            if (value == null) {
                m.appendReplacement(sb, "");
                continue;
            }
            String s = value.toString();
            StringBuilder encoded = new StringBuilder();
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\\') {
                    encode = true;
                    encoded.append('\\').append('\\').append('\\').append('\\');
                    continue;
                }
                if (ENCODE_CHARACTERS.contains(Character.valueOf(c))) {
                    encode = true;
                    encoded.append('\\');
                }
                encoded.append(c);
            }
            m.appendReplacement(sb, encoded.toString());
        }
        if (encode) {
            StringBuffer uncode = new StringBuffer();
            int i = 0;
            int len = sb.length();
            while (i < len) {
                char c = sb.charAt(i);
                if (++i < len && c == '\\') {
                    char n = sb.charAt(i);
                    if (n == '\\') {
                        ++i;
                        uncode.append(c);
                        continue;
                    }
                    if (ENCODE_CHARACTERS.contains(Character.valueOf(n))) continue;
                    uncode.append(c);
                    continue;
                }
                uncode.append(c);
            }
            sb = uncode;
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

