/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.metadata;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.exception.IllegalConfigurationException;
import cn.tenmg.flink.jobs.metadata.MetaDataGetter;
import java.util.HashMap;
import java.util.Map;

public abstract class MetaDataGetterFactory {
    @Deprecated
    private static final String COLUMNS_GETTER_KEY_PREFIX = "data.sync.metadata.getter.";
    private static final String METADATA_GETTER_KEY_PREFIX = "metadata.getter.";
    private static volatile Map<String, MetaDataGetter> COLUMNS_GETTERS = new HashMap<String, MetaDataGetter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaDataGetter getMetaDataGetter(Map<String, String> dataSource) {
        String connector = dataSource.get("connector");
        MetaDataGetter columnsGetter = COLUMNS_GETTERS.get(connector);
        if (columnsGetter == null) {
            Map<String, MetaDataGetter> map = COLUMNS_GETTERS;
            synchronized (map) {
                columnsGetter = COLUMNS_GETTERS.get(connector);
                if (columnsGetter == null) {
                    String key = METADATA_GETTER_KEY_PREFIX + connector;
                    String className = FlinkJobsContext.getProperty(key);
                    if (className == null) {
                        className = FlinkJobsContext.getProperty(COLUMNS_GETTER_KEY_PREFIX + connector);
                    }
                    if (className == null) {
                        throw new IllegalArgumentException("MetaDataGetter for connector '" + connector + "' is not supported, Please consider manually implementing the interface " + MetaDataGetter.class.getName() + " and specifying the configuration key '" + key + "' to your own class name in the configuration file " + FlinkJobsContext.getConfigurationFile());
                    }
                    if (StringUtils.isBlank((String)className)) {
                        throw new IllegalConfigurationException("The configuration of key '" + key + "' must be not blank");
                    }
                    try {
                        columnsGetter = (MetaDataGetter)Class.forName(className).newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Cannot instantiate MetaDataGetter for connector '" + connector + "'", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Wrong MetaDataGetter configuration for connector " + connector + "'", e);
                    }
                    COLUMNS_GETTERS.put(connector, columnsGetter);
                }
            }
        }
        return columnsGetter;
    }
}

