/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.context;

import cn.tenmg.dsl.utils.PropertiesLoaderUtils;
import cn.tenmg.flink.jobs.exception.DataSourceNotFoundException;
import cn.tenmg.flink.jobs.kit.HashMapKit;
import cn.tenmg.flink.jobs.utils.ConfigurationUtils;
import cn.tenmg.flink.jobs.utils.PlaceHolderUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkJobsContext {
    private static Logger log = LoggerFactory.getLogger(FlinkJobsContext.class);
    public static final String CONFIG_SPLITER = ".";
    public static final String SMART_MODE_CONFIG_KEY = "flink.jobs.smart";
    private static final ThreadLocal<Map<Object, Object>> resources = new InheritableThreadLocalMap();
    private static final Map<String, Map<String, String>> datasources = new HashMap<String, Map<String, String>>();
    private static final Map<String, String> autoDatasource = new HashMap<String, String>();
    private static final Map<String, String> tableExecConfigs = new HashMap<String, String>();
    private static final String DEFAULT_STRATEGIES_PATH = "flink-jobs-context-loader.properties";
    private static final String CONFIG_LOCATION_KEY = "config.location";
    private static final String CONTEXT_LOCATION_KEY = "context.location";
    private static final String DATASOURCE_PREFIX = "datasource.";
    private static final String AUTO_DATASOURCE_PREFIX = "auto.datasource.";
    private static final String DATASOURCE_REGEX = "^" + "datasource.".replaceAll("\\.", "\\\\.") + "([\\S]+\\.){0,1}[^\\.]+$";
    private static final String AUTO_DATASOURCE_REGEX = "^" + "auto.datasource.".replaceAll("\\.", "\\\\.") + "[^\\.]+$";
    private static final String EXECUTION_ENVIRONMENT = "ExecutionEnvironment";
    private static final String CURRENT_CONFIGURATION = "CurrentConfiguration";
    private static final String AUOT_DATASOURCE_IDENTIFIER = "auto.datasource.identifier";
    private static Properties defaultProperties;
    private static Properties configProperties;

    public static String getCurrentConfiguration() {
        return (String)FlinkJobsContext.get(CURRENT_CONFIGURATION);
    }

    public static StreamExecutionEnvironment getExecutionEnvironment() {
        StreamExecutionEnvironment env = (StreamExecutionEnvironment)FlinkJobsContext.get(EXECUTION_ENVIRONMENT);
        if (env == null) {
            env = StreamExecutionEnvironment.getExecutionEnvironment();
            FlinkJobsContext.put(EXECUTION_ENVIRONMENT, env);
        }
        return env;
    }

    public static StreamExecutionEnvironment getExecutionEnvironment(String configuration) {
        if (configuration == null) {
            return FlinkJobsContext.getExecutionEnvironment();
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)org.apache.flink.configuration.ConfigurationUtils.createConfiguration((Properties)FlinkJobsContext.loadConfiguration(new Properties(), configuration)));
        FlinkJobsContext.put(CURRENT_CONFIGURATION, configuration);
        FlinkJobsContext.put(EXECUTION_ENVIRONMENT, env);
        return env;
    }

    public static StreamTableEnvironment getOrCreateStreamTableEnvironment() {
        return FlinkJobsContext.getOrCreateStreamTableEnvironment(FlinkJobsContext.getExecutionEnvironment());
    }

    public static StreamTableEnvironment getOrCreateStreamTableEnvironment(StreamExecutionEnvironment env) {
        StreamTableEnvironment tableEnv = (StreamTableEnvironment)FlinkJobsContext.get(env);
        if (tableEnv == null) {
            tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
            TableConfig tableConfig = tableEnv.getConfig();
            Properties properties = new Properties();
            properties.putAll(FlinkJobsContext.getTableExecConfigs());
            FlinkJobsContext.loadConfiguration(properties, FlinkJobsContext.getCurrentConfiguration());
            tableConfig.addConfiguration(org.apache.flink.configuration.ConfigurationUtils.createConfiguration((Properties)properties));
            FlinkJobsContext.put(env, tableEnv);
            FlinkJobsContext.put(tableEnv, tableEnv.getCurrentCatalog());
        }
        return tableEnv;
    }

    public static String getDefaultCatalog(StreamTableEnvironment tableEnv) {
        String catalog = (String)FlinkJobsContext.get(tableEnv);
        if (catalog == null) {
            catalog = tableEnv.getCurrentCatalog();
            FlinkJobsContext.put(tableEnv, catalog);
        }
        return catalog;
    }

    public static String getProperty(String key) {
        return configProperties.containsKey(key) ? configProperties.getProperty(key) : defaultProperties.getProperty(key);
    }

    public static String getDefaultJDBCDriver(String productName) {
        return FlinkJobsContext.getProperty("jdbc." + productName + CONFIG_SPLITER + "driver");
    }

    public static Map<Object, Object> getResources() {
        if (resources.get() == null) {
            return Collections.emptyMap();
        }
        return new HashMap<Object, Object>(resources.get());
    }

    public static void setResources(Map<Object, Object> newResources) {
        if (newResources == null || newResources.isEmpty()) {
            return;
        }
        FlinkJobsContext.ensureResourcesInitialized();
        resources.get().clear();
        resources.get().putAll(newResources);
    }

    public static Map<String, Map<String, String>> getDatasources() {
        return datasources;
    }

    public static String getConfigurationFile() {
        return defaultProperties.getProperty(CONFIG_LOCATION_KEY, "flink-jobs.properties");
    }

    public static Map<String, String> getDatasource(String name) {
        Map<String, String> dataSource = datasources.get(name);
        if (dataSource == null) {
            if (autoDatasource.isEmpty()) {
                throw new DataSourceNotFoundException("DataSource named " + name + " not found, Please check the configuration file " + FlinkJobsContext.getConfigurationFile());
            }
            log.info("Automatically generate a DataSource named " + name);
            dataSource = HashMapKit.init(autoDatasource).put(autoDatasource.get(AUOT_DATASOURCE_IDENTIFIER), name).get();
            dataSource.remove(AUOT_DATASOURCE_IDENTIFIER);
        }
        return dataSource;
    }

    public static Map<String, String> getTableExecConfigs() {
        return tableExecConfigs;
    }

    public static Object get(Object key) {
        return FlinkJobsContext.getValue(key);
    }

    public static void put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            FlinkJobsContext.remove(key);
            return;
        }
        FlinkJobsContext.ensureResourcesInitialized();
        resources.get().put(key, value);
    }

    public static Object remove(Object key) {
        Map<Object, Object> perThreadResources = resources.get();
        return perThreadResources != null ? perThreadResources.remove(key) : null;
    }

    public static void remove() {
        resources.remove();
    }

    private static Object getValue(Object key) {
        Map<Object, Object> perThreadData = resources.get();
        return perThreadData != null ? perThreadData.get(key) : null;
    }

    private static void ensureResourcesInitialized() {
        if (resources.get() == null) {
            resources.set(new HashMap());
        }
    }

    private static Properties loadConfiguration(Properties properties, String configuration) {
        Map<String, String> config = ConfigurationUtils.load(configuration);
        if (config != null) {
            properties.putAll(config);
        }
        return properties;
    }

    static {
        try {
            defaultProperties = PropertiesLoaderUtils.loadFromClassPath((String)DEFAULT_STRATEGIES_PATH);
        }
        catch (Exception e) {
            log.warn("flink-jobs-context-loader.properties not found in the classpath.", (Throwable)e);
            defaultProperties = new Properties();
        }
        String contextFile = defaultProperties.getProperty(CONTEXT_LOCATION_KEY, "flink-jobs-context.properties");
        try {
            defaultProperties.putAll((Map<?, ?>)PropertiesLoaderUtils.loadFromClassPath((String)contextFile));
        }
        catch (Exception e) {
            log.warn(contextFile + " not found in the classpath.", (Throwable)e);
        }
        String configurationFile = FlinkJobsContext.getConfigurationFile();
        try {
            Object value;
            configProperties = PropertiesLoaderUtils.loadFromClassPath((String)configurationFile);
            for (Map.Entry<Object, Object> entry : configProperties.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                configProperties.put(entry.getKey(), PlaceHolderUtils.replace(value.toString(), configProperties));
            }
            boolean ignoreCase = Boolean.valueOf(FlinkJobsContext.getProperty("data.sync.timestamp.case_sensitive")) == false;
            int configSpliterLen = CONFIG_SPLITER.length();
            int datasourcePrefixLen = DATASOURCE_PREFIX.length();
            int autoDatasourcePrefixLen = AUTO_DATASOURCE_PREFIX.length();
            for (Map.Entry<Object, Object> entry : configProperties.entrySet()) {
                String keyLowercase;
                String name;
                int index;
                String param;
                String key = entry.getKey().toString();
                value = entry.getValue();
                if (key.matches(DATASOURCE_REGEX)) {
                    param = key.substring(datasourcePrefixLen);
                    index = param.indexOf(CONFIG_SPLITER);
                    if (index <= 0) continue;
                    name = param.substring(0, index);
                    param = param.substring(index + configSpliterLen);
                    Map<String, String> dataSource = datasources.get(name);
                    if (dataSource == null) {
                        dataSource = new LinkedHashMap<String, String>();
                        datasources.put(name, dataSource);
                    }
                    dataSource.put(param, value.toString());
                    continue;
                }
                if (key.matches(AUTO_DATASOURCE_REGEX)) {
                    param = key.substring(autoDatasourcePrefixLen);
                    index = param.indexOf(CONFIG_SPLITER);
                    if (index <= 0) continue;
                    name = param.substring(0, index);
                    param = param.substring(index + configSpliterLen);
                    autoDatasource.put(param, value.toString());
                    continue;
                }
                if (key.startsWith("table.exec")) {
                    tableExecConfigs.put(key, value.toString());
                    continue;
                }
                if (!ignoreCase || !key.matches("^data\\.sync\\.[^\\.]+\\.((from|to)_type|script|strategy)$") || key.equals(keyLowercase = key.toLowerCase()) || defaultProperties.containsKey(keyLowercase)) continue;
                defaultProperties.put(keyLowercase, value);
            }
        }
        catch (Exception e) {
            log.info("Configuration file " + configurationFile + " not found in classpath, the default configuration will be used.");
            configProperties = new Properties();
        }
    }

    private static final class InheritableThreadLocalMap<T extends Map<Object, Object>>
    extends InheritableThreadLocal<Map<Object, Object>> {
        private InheritableThreadLocalMap() {
        }

        @Override
        protected Map<Object, Object> childValue(Map<Object, Object> parentValue) {
            if (parentValue != null) {
                return (Map)((HashMap)parentValue).clone();
            }
            return null;
        }
    }
}

