/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator;

import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.model.ExecuteSql;
import cn.tenmg.flink.jobs.operator.AbstractSqlOperator;
import cn.tenmg.flink.jobs.utils.ConfigurationUtils;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import cn.tenmg.flink.jobs.utils.JSONUtils;
import cn.tenmg.flink.jobs.utils.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteSqlOperator
extends AbstractSqlOperator<ExecuteSql> {
    private static Logger log = LoggerFactory.getLogger(ExecuteSqlOperator.class);
    private static final String DELETE_CLAUSE_REGEX = "[\\s]*[D|d][E|e][L|l][E|e][T|t][E|e][\\s]+[F|f][R|r][O|o][M|m][\\s]+[\\S]+";
    private static final String UPDATE_CLAUSE_REGEX = "[\\s]*[U|u][P|p][D|d][A|a][T|t][E|e][\\s]+[\\S]+[\\s]+[S|s][E|e][T|t][\\s]+[\\S]+";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object execute(StreamTableEnvironment tableEnv, ExecuteSql sql, Map<String, Object> params) throws Exception {
        NamedScript namedScript = DSLUtils.parse((String)sql.getScript(), params);
        String datasource = sql.getDataSource();
        String statement = namedScript.getScript();
        if (StringUtils.isNotBlank((String)datasource)) {
            Map<String, String> dataSource = FlinkJobsContext.getDatasource(datasource);
            if (ConfigurationUtils.isJDBC(dataSource) && (statement.matches(DELETE_CLAUSE_REGEX) || statement.matches(UPDATE_CLAUSE_REGEX))) {
                Long l;
                Script script = DSLUtils.toScript((String)namedScript.getScript(), (Map)namedScript.getParams(), (ParamsParser)JDBCParamsParser.getInstance());
                statement = script.getValue();
                Connection con = null;
                PreparedStatement ps = null;
                try {
                    con = JDBCUtils.getConnection(dataSource);
                    con.setAutoCommit(true);
                    ps = con.prepareStatement(statement);
                    List parameters = (List)script.getParams();
                    JDBCUtils.setParams(ps, parameters);
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Execute JDBC SQL: %s; parameters: %s", statement, JSONUtils.toJSONString(parameters)));
                    }
                    l = ps.executeLargeUpdate();
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(ps);
                    JDBCUtils.close(con);
                    throw throwable;
                }
                JDBCUtils.close(ps);
                JDBCUtils.close(con);
                return l;
            }
            statement = SQLUtils.toSQL(namedScript);
            statement = SQLUtils.wrapDataSource(statement, dataSource);
        } else {
            statement = SQLUtils.toSQL(namedScript);
        }
        if (log.isInfoEnabled()) {
            log.info("Execute Flink SQL: " + SQLUtils.hiddePassword(statement));
        }
        return tableEnv.executeSql(statement);
    }

    public static void main(String[] args) {
        System.out.println(SQLUtils.toSQL(new NamedScript("#asdfs")));
    }
}

