/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.datasource.DatasourceBuilder;
import cn.tenmg.flink.jobs.exception.IllegalConfigurationException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public abstract class JDBCUtils {
    private static final String JDBC_PRODUCT_SPLIT = ":";
    private static final String TYPE_NAME = "type";
    private static final String[] DEFAULT_TYPES = new String[]{"com.alibaba.druid.pool.DruidDataSource", "org.apache.commons.dbcp2.BasicDataSource"};
    private static final String BUILDER_PREFIX = "cn.tenmg.flink.jobs.datasource.builder.";
    private static final String BUILDER_SUFFIX = "Builder";
    private static final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    private JDBCUtils() {
    }

    public static final String getProduct(String url) {
        String tmp = url.substring(url.indexOf(JDBC_PRODUCT_SPLIT) + 1);
        return tmp.substring(0, tmp.indexOf(JDBC_PRODUCT_SPLIT));
    }

    public static final Connection getConnection(Map<String, String> dataSource) throws SQLException, ClassNotFoundException {
        String driver = dataSource.get("driver");
        String url = dataSource.get("url");
        if (StringUtils.isBlank((String)driver)) {
            driver = FlinkJobsContext.getDefaultJDBCDriver(JDBCUtils.getProduct(url));
        }
        Class.forName(driver);
        return DriverManager.getConnection(url, dataSource.get("username"), dataSource.get("password"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Connection getConnection(String name) throws SQLException, ClassNotFoundException {
        DataSource dataSource = dataSources.get(name);
        if (dataSource == null) {
            Map<String, DataSource> map = dataSources;
            synchronized (map) {
                dataSource = dataSources.get(name);
                if (dataSource == null) {
                    Map<String, String> datasource = FlinkJobsContext.getDatasource(name);
                    String type = datasource.get(TYPE_NAME);
                    if (StringUtils.isBlank((String)type)) {
                        for (int i = 0; i < DEFAULT_TYPES.length; ++i) {
                            String defaultType = DEFAULT_TYPES[i];
                            if (!JDBCUtils.isPresent(defaultType)) continue;
                            type = defaultType;
                            break;
                        }
                    }
                    if (StringUtils.isBlank((String)type)) {
                        return JDBCUtils.getConnection(datasource);
                    }
                    String buildName = BUILDER_PREFIX.concat(type).concat(BUILDER_SUFFIX);
                    try {
                        Class<?> datasourceBuilder = Class.forName(buildName);
                        Properties properties = new Properties();
                        properties.putAll(datasource);
                        dataSource = ((DatasourceBuilder)datasourceBuilder.newInstance()).createDataSource(properties);
                        dataSources.put(name, dataSource);
                    }
                    catch (Throwable e) {
                        throw new IllegalConfigurationException("This type of datasource is not supported at the moment: " + type, e);
                    }
                }
            }
        }
        return dataSource.getConnection();
    }

    public static void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void setParams(PreparedStatement ps, List<Object> params) throws SQLException {
        if (params == null || params.isEmpty()) {
            return;
        }
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            ps.setObject(i + 1, params.get(i));
        }
    }

    private static boolean isPresent(String className) {
        try {
            Class.forName(className, false, JDBCUtils.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

