/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.Operator;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import java.util.HashMap;
import java.util.Map;

public abstract class OperatorUtils {
    private static final String KEY_PREFIX = "operator.";
    private static volatile Map<String, Operator> operators = new HashMap<String, Operator>();

    public static Operator getOperator(String type) {
        if (operators.containsKey(type)) {
            return operators.get(type);
        }
        Map<String, Operator> map = operators;
        synchronized (map) {
            if (operators.containsKey(type)) {
                return operators.get(type);
            }
            String className = FlinkJobsContext.getProperty(KEY_PREFIX + type);
            if (className == null) {
                throw new IllegalArgumentException("Operate of type " + type + " is not supported");
            }
            if (StringUtils.isBlank((String)className)) {
                throw new IllegalArgumentException("Cannot find operator for operate of type " + type);
            }
            try {
                Operator operator = (Operator)Class.forName(className).newInstance();
                operators.put(type, operator);
                return operator;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate operator for operate of type " + type, e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Wrong operator configuration for operate of type " + type, e);
            }
        }
    }
}

