/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.parser.FlinkSQLParamsParser;
import cn.tenmg.flink.jobs.utils.ConfigurationUtils;
import cn.tenmg.flink.jobs.utils.MapUtils;
import cn.tenmg.flink.jobs.utils.MatchUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SQLUtils {
    public static final String SINGLE_QUOTATION_MARK = "'";
    public static final String SPACE_EQUALS_SPACE = " = ";
    public static final String TABLE_NAME = "table-name";
    public static final String RESERVED_KEYWORD_WRAP_PREFIX = "`";
    public static final String RESERVED_KEYWORD_WRAP_SUFFIX = "`";
    private static final Pattern passwordPattern = Pattern.compile("\\'password\\'[\\s]*\\=[\\s]*\\'[^']*[^,]*\\'");
    private static final Pattern WITH_CLAUSE_PATTERN = Pattern.compile("[W|w][I|i][T|t][H|h][\\s]*\\([\\s\\S]*\\)[\\s]*$");
    private static final Pattern CREATE_CLAUSE_PATTERN = Pattern.compile("[C|c][R|r][E|e][A|a][T|t][E|e][\\s]+[T|t][A|a][B|b][L|l][E|e][\\s]+[^\\s\\(]+");
    private static final Set<String> sqlReservedKeywords = new HashSet<String>();
    private static final Set<String> smartTableMameConnectors = new HashSet<String>();

    public static String toSQL(NamedScript namedScript) {
        return SQLUtils.toSQL(namedScript.getScript(), namedScript.getParams());
    }

    public static String toSQL(String namedscript, Map<String, ?> params) {
        return DSLUtils.toScript((String)namedscript, params, (ParamsParser)FlinkSQLParamsParser.getInstance()).getValue();
    }

    public static void appendDataSource(StringBuffer sqlBuffer, Map<String, String> dataSource) {
        Iterator<Map.Entry<String, String>> it = dataSource.entrySet().iterator();
        Map.Entry<String, String> entry = it.next();
        SQLUtils.appendProperty(sqlBuffer, entry);
        while (it.hasNext()) {
            entry = it.next();
            sqlBuffer.append(',').append(' ');
            SQLUtils.appendProperty(sqlBuffer, entry);
        }
    }

    public static void appendDataSource(StringBuffer sqlBuffer, Map<String, String> dataSource, String defaultTableName) {
        SQLUtils.appendDataSource(sqlBuffer, dataSource);
        if (SQLUtils.needDefaultTableName(dataSource) && !dataSource.containsKey(TABLE_NAME)) {
            sqlBuffer.append(',').append(' ').append(SQLUtils.wrapString(TABLE_NAME));
            SQLUtils.apppendEquals(sqlBuffer);
            sqlBuffer.append(SQLUtils.wrapString(defaultTableName));
        }
    }

    private static void appendDataSource(String script, Map<String, String> dataSource, StringBuffer sqlBuffer) {
        SQLUtils.appendDataSource(sqlBuffer, dataSource);
        if (SQLUtils.needDefaultTableName(dataSource) && !dataSource.containsKey(TABLE_NAME)) {
            SQLUtils.extractAndApppendDefaultTableName(sqlBuffer, script);
        }
    }

    public static String wrapString(String value) {
        return SINGLE_QUOTATION_MARK + value.replaceAll(SINGLE_QUOTATION_MARK, "\\\\'") + SINGLE_QUOTATION_MARK;
    }

    public static void apppendEquals(StringBuffer sqlBuffer) {
        sqlBuffer.append(SPACE_EQUALS_SPACE);
    }

    public static String hiddePassword(String sql) {
        Matcher matcher = passwordPattern.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "'password' = <hidden>");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String wrapDataSource(String script, Map<String, String> dataSource) throws IOException {
        Matcher matcher = WITH_CLAUSE_PATTERN.matcher(script);
        StringBuffer sqlBuffer = new StringBuffer();
        if (matcher.find()) {
            String group = matcher.group();
            int startIndex = group.indexOf("(") + 1;
            int endIndex = group.lastIndexOf(")");
            String start = group.substring(0, startIndex);
            String value = group.substring(startIndex, endIndex);
            String end = group.substring(endIndex);
            if (StringUtils.isBlank((String)value)) {
                matcher.appendReplacement(sqlBuffer, start);
                SQLUtils.appendDataSource(script, dataSource, sqlBuffer);
                sqlBuffer.append(end);
            } else {
                char c;
                int i;
                Map<String, String> config = ConfigurationUtils.load(value);
                HashMap<String, String> actualDataSource = MapUtils.newHashMap(dataSource);
                MapUtils.removeAll(actualDataSource, config.keySet());
                matcher.appendReplacement(sqlBuffer, start);
                StringBuilder blank = new StringBuilder();
                int len = value.length();
                for (i = len - 1; i > 0 && (c = value.charAt(i)) <= ' '; --i) {
                    blank.append(c);
                }
                sqlBuffer.append(value.substring(0, i + 1)).append(',').append(' ');
                SQLUtils.appendDataSource(script, actualDataSource, sqlBuffer);
                sqlBuffer.append((CharSequence)blank.reverse()).append(end);
            }
        } else {
            sqlBuffer.append(script);
            sqlBuffer.append(" WITH (");
            SQLUtils.appendDataSource(script, dataSource, sqlBuffer);
            sqlBuffer.append(")");
        }
        return sqlBuffer.toString();
    }

    public static String wrapIfReservedKeywords(String word) {
        if (word != null && sqlReservedKeywords.contains(word.toUpperCase())) {
            return "`" + word + "`";
        }
        return word;
    }

    public static boolean needDefaultTableName(Map<String, String> dataSource) {
        return MatchUtils.matchesAny(smartTableMameConnectors, dataSource.get("connector"));
    }

    public static void apppendDefaultTableName(StringBuffer sqlBuffer, String defaultTableName) {
        sqlBuffer.append(',').append(' ').append(SQLUtils.wrapString(TABLE_NAME));
        SQLUtils.apppendEquals(sqlBuffer);
        sqlBuffer.append(SQLUtils.wrapString(SQLUtils.wrapIfReservedKeywords(defaultTableName)));
    }

    private static void extractAndApppendDefaultTableName(StringBuffer sqlBuffer, String script) {
        Matcher createMatcher = CREATE_CLAUSE_PATTERN.matcher(script);
        if (createMatcher.find()) {
            char c;
            String group = createMatcher.group();
            StringBuilder tableNameBuilder = new StringBuilder();
            int i = group.length();
            while (--i > 0) {
                c = group.charAt(i);
                if (c <= ' ') continue;
                tableNameBuilder.append(c);
                break;
            }
            while (--i > 0 && (c = group.charAt(i)) > ' ') {
                tableNameBuilder.append(c);
            }
            SQLUtils.apppendDefaultTableName(sqlBuffer, tableNameBuilder.reverse().toString());
        }
    }

    private static void appendProperty(StringBuffer sqlBuffer, Map.Entry<String, String> entry) {
        sqlBuffer.append(SQLUtils.wrapKey(entry.getKey()));
        SQLUtils.apppendEquals(sqlBuffer);
        sqlBuffer.append(SQLUtils.wrapValue(entry.getValue()));
    }

    private static String wrapKey(String value) {
        return SQLUtils.isString(value) ? value : SQLUtils.wrapString(value);
    }

    private static boolean isString(String value) {
        return value.startsWith(SINGLE_QUOTATION_MARK) && value.endsWith(SINGLE_QUOTATION_MARK);
    }

    private static String wrapValue(String value) {
        if (value == null) {
            return "null";
        }
        if (SQLUtils.isString(value)) {
            return value;
        }
        return SQLUtils.wrapString(value);
    }

    private static void addReservedKeywords(String keywords) {
        if (StringUtils.isNotBlank((String)keywords)) {
            String[] words = keywords.split(",");
            for (int i = 0; i < words.length; ++i) {
                sqlReservedKeywords.add(words[i].trim().toUpperCase());
            }
        }
    }

    static {
        SQLUtils.addReservedKeywords(FlinkJobsContext.getProperty("flink.sql.reserved.keywords"));
        SQLUtils.addReservedKeywords(FlinkJobsContext.getProperty("flink.sql.custom.keywords"));
        String config = FlinkJobsContext.getProperty("flink.sql.smart.table-name");
        if (config != null) {
            String[] connectors = config.split(",");
            for (int i = 0; i < connectors.length; ++i) {
                smartTableMameConnectors.add(connectors[i].trim());
            }
        }
        SQLUtils.addReservedKeywords(FlinkJobsContext.getProperty("sql.reserved.keywords"));
        SQLUtils.addReservedKeywords(FlinkJobsContext.getProperty("sql.custom.keywords"));
    }
}

