/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.jdbc.executor;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.jdbc.exception.SQLExecutorException;
import cn.tenmg.flink.jobs.jdbc.executor.ReadOnlySQLExecutor;
import cn.tenmg.flink.jobs.utils.FieldUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetSQLExecutor<T>
extends ReadOnlySQLExecutor<T> {
    protected Class<T> type;

    protected GetSQLExecutor() {
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public GetSQLExecutor(Class<T> type) {
        this.type = type;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ResultSet executeQuery(PreparedStatement ps) throws SQLException {
        return ps.executeQuery();
    }

    @Override
    public T execute(PreparedStatement ps, ResultSet rs) throws SQLException {
        Object row = null;
        if (rs.next()) {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            if (Map.class.isAssignableFrom(this.type)) {
                int i;
                ArrayList<String> feildNames = new ArrayList<String>();
                for (i = 1; i <= columnCount; ++i) {
                    feildNames.add(StringUtils.toCamelCase((String)rsmd.getColumnLabel(i), (String)"_", (boolean)false));
                }
                try {
                    row = this.type.newInstance();
                    for (i = 1; i <= columnCount; ++i) {
                        ((Map)row).put(feildNames.get(i - 1), rs.getObject(i));
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new SQLExecutorException(e);
                }
            }
            if (BigDecimal.class.isAssignableFrom(this.type)) {
                row = rs.getBigDecimal(1);
            } else if (Number.class.isAssignableFrom(this.type)) {
                Object obj = rs.getObject(1);
                if (obj == null) {
                    return null;
                }
                if (obj instanceof Number) {
                    if (Double.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).doubleValue();
                    } else if (Float.class.isAssignableFrom(this.type)) {
                        obj = Float.valueOf(((Number)obj).floatValue());
                    } else if (Integer.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).intValue();
                    } else if (Long.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).longValue();
                    } else if (Short.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).shortValue();
                    } else if (Byte.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).byteValue();
                    }
                }
                row = obj;
            } else if (String.class.isAssignableFrom(this.type)) {
                row = rs.getString(1);
            } else if (Date.class.isAssignableFrom(this.type)) {
                row = rs.getObject(1);
            } else {
                if (List.class.isAssignableFrom(this.type)) {
                    try {
                        row = this.type.newInstance();
                        for (int i = 1; i <= columnCount; ++i) {
                            ((List)row).add(rs.getObject(i));
                        }
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new SQLExecutorException(e);
                    }
                }
                HashMap<String, Integer> feildNames = new HashMap<String, Integer>();
                for (int i = 1; i <= columnCount; ++i) {
                    String feildName = StringUtils.toCamelCase((String)rsmd.getColumnLabel(i), (String)"_", (boolean)false);
                    feildNames.put(feildName, i);
                }
                HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
                Class<T> current = this.type;
                while (!Object.class.equals(current)) {
                    FieldUtils.parseFields(feildNames, fieldMap, current.getDeclaredFields());
                    current = current.getSuperclass();
                }
                try {
                    row = this.type.newInstance();
                    for (int i = 1; i <= columnCount; ++i) {
                        Field field = (Field)fieldMap.get(i);
                        if (field == null) continue;
                        field.set(row, GetSQLExecutor.getValue(rs, i, field.getType()));
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new SQLExecutorException(e);
                }
            }
        }
        if (rs.next()) {
            throw new SQLExecutorException("Statement returned more than one row, where no more than one was expected.");
        }
        return (T)row;
    }
}

