/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.utils.DSLUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ConfigurationUtils {
    public static final String EMPTY_STRING = "";
    private static final char VALUE_BEGIN = '=';
    private static final Set<Character> VALUE_END = new HashSet<Character>(){
        private static final long serialVersionUID = 3151893719267729294L;
        {
            this.add(Character.valueOf(','));
            this.add(Character.valueOf('\r'));
            this.add(Character.valueOf('\n'));
        }
    };

    public static Map<String, String> load(String config) {
        if (config == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        config = config.trim();
        int len = config.length();
        int i = 0;
        int backslashes = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isKey = true;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        while (i < len) {
            char c = config.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd((char)a, (char)b, (char)c, (int)backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
                if (isKey) {
                    key.append(c);
                } else {
                    value.append(c);
                }
            } else if (c == '\'') {
                isString = true;
                if (isKey) {
                    key.append(c);
                } else {
                    value.append(c);
                }
            } else if (isKey) {
                if (c == '=') {
                    isKey = false;
                } else {
                    key.append(c);
                }
            } else {
                if (VALUE_END.contains(Character.valueOf(c))) {
                    isKey = true;
                    ConfigurationUtils.put(map, key, value);
                    key.setLength(0);
                    value.setLength(0);
                    a = b;
                    b = c;
                    ++i;
                    while (i < len && (c = config.charAt(i)) <= ' ') {
                        a = b;
                        b = c;
                        ++i;
                    }
                    continue;
                }
                value.append(c);
            }
            a = b;
            b = c;
            ++i;
        }
        if (key.length() > 0) {
            ConfigurationUtils.put(map, key, value);
        }
        return map;
    }

    public static boolean isJDBC(Map<String, String> dataSource) {
        return "jdbc".equals(dataSource.get("connector"));
    }

    public static boolean isKafka(Map<String, String> dataSource) {
        return "kafka".equals(dataSource.get("connector"));
    }

    private static void put(Map<String, String> map, StringBuilder key, StringBuilder value) {
        String k = key.toString().trim();
        String v = value.toString().trim();
        int last = k.length() - 1;
        if (k.charAt(0) == '\'' && k.charAt(last) == '\'') {
            k = k.substring(1, last);
        }
        map.put(k, v);
    }
}

