/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.datasource.DataSourceFilter;
import cn.tenmg.flink.jobs.exception.IllegalConfigurationException;
import cn.tenmg.flink.jobs.utils.MapUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class DataSourceFilterUtils {
    private static final Map<String, DataSourceFilter> filters = new HashMap<String, DataSourceFilter>();

    public static DataSourceFilter getDataSourceFilter(String name) {
        DataSourceFilter filter = filters.get(name);
        if (filter == null) {
            try {
                filter = (DataSourceFilter)Class.forName(name).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalConfigurationException("Failed to load DataSourceFilter " + name, e);
            }
        }
        return filter;
    }

    public static Map<String, String> filter(String name, Map<String, String> dataSource) {
        if (StringUtils.isBlank((String)name)) {
            return dataSource;
        }
        HashMap<String, String> newDataSource = MapUtils.newHashMap(dataSource);
        DataSourceFilterUtils.getDataSourceFilter(name).doFilter(newDataSource);
        return newDataSource;
    }

    static {
        ServiceLoader<DataSourceFilter> loader = ServiceLoader.load(DataSourceFilter.class);
        for (DataSourceFilter filter : loader) {
            filters.put(StringUtils.toCamelCase((String)filter.getClass().getSimpleName().replace("DataSourceFilter", ""), null, (boolean)false), filter);
        }
    }
}

