/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator;

import bsh.EvalError;
import bsh.Interpreter;
import cn.tenmg.flink.jobs.model.Bsh;
import cn.tenmg.flink.jobs.model.bsh.Var;
import cn.tenmg.flink.jobs.operator.AbstractOperator;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

public class BshOperator
extends AbstractOperator<Bsh> {
    private static final String ENV = "env";
    private static final String DATA_HOLDER = "DataHolder";

    @Override
    public Object execute(StreamExecutionEnvironment env, Bsh bsh, Map<String, Object> params) throws Exception {
        Interpreter interpreter = new Interpreter();
        String java = bsh.getJava();
        List<Var> vars = bsh.getVars();
        interpreter.set(ENV, (Object)env);
        interpreter.set(DATA_HOLDER, params);
        BshOperator.setVars(interpreter, vars, params);
        return interpreter.eval(java);
    }

    private static void setVars(Interpreter interpreter, List<Var> vars, Map<String, Object> params) throws EvalError {
        if (vars == null || vars.isEmpty()) {
            return;
        }
        int size = vars.size();
        for (int i = 0; i < size; ++i) {
            Var var = vars.get(i);
            String name = var.getName();
            String value = var.getValue();
            if (name == null) continue;
            Object param = null;
            if (value == null) {
                param = params.get(name);
            } else {
                param = params.get(value);
                if (param == null) {
                    param = value;
                }
            }
            interpreter.set(name, param);
        }
    }
}

