/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.jdbc.executor;

import cn.tenmg.dsl.utils.ObjectUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.jdbc.ResultGetter;
import cn.tenmg.flink.jobs.jdbc.SQLExecutor;
import cn.tenmg.flink.jobs.jdbc.exception.SQLExecutorException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class ReadOnlySQLExecutor<T>
implements SQLExecutor<T> {
    private static final Map<Class<?>, ResultGetter> RESULT_GETTERS = new HashMap();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static <T> T getRow(ResultSet rs, Class<T> type) throws SQLException {
        void var2_30;
        ResultGetter resultGetter = RESULT_GETTERS.get(type);
        if (resultGetter == null) {
            int i;
            if (Map.class.isAssignableFrom(type)) {
                int i2;
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                ArrayList<String> feildNames = new ArrayList<String>();
                for (i2 = 1; i2 <= columnCount; ++i2) {
                    feildNames.add(StringUtils.toCamelCase((String)rsmd.getColumnLabel(i2), (String)"_", (boolean)false));
                }
                try {
                    T t = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                    for (i2 = 1; i2 <= columnCount; ++i2) {
                        ((Map)t).put(feildNames.get(i2 - 1), rs.getObject(i2));
                    }
                    return var2_30;
                }
                catch (Exception e) {
                    throw new SQLExecutorException(e);
                }
            }
            if (List.class.isAssignableFrom(type)) {
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                try {
                    T t = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                    for (int i3 = 1; i3 <= columnCount; ++i3) {
                        ((List)t).add(rs.getObject(i3));
                    }
                    return var2_30;
                }
                catch (Exception e) {
                    throw new SQLExecutorException(e);
                }
            }
            if (Ref.class.isAssignableFrom(type)) {
                Ref ref = rs.getRef(1);
                return var2_30;
            }
            if (Array.class.isAssignableFrom(type)) {
                Array array = rs.getArray(1);
                return var2_30;
            }
            if (SQLXML.class.isAssignableFrom(type)) {
                SQLXML sQLXML = rs.getSQLXML(1);
                return var2_30;
            }
            if (Blob.class.isAssignableFrom(type)) {
                Blob blob = rs.getBlob(1);
                return var2_30;
            }
            if (Clob.class.isAssignableFrom(type)) {
                Clob clob = rs.getClob(1);
                return var2_30;
            }
            if (NClob.class.isAssignableFrom(type)) {
                NClob nClob = rs.getNClob(1);
                return var2_30;
            }
            if (RowId.class.isAssignableFrom(type)) {
                RowId rowId = rs.getRowId(1);
                return var2_30;
            }
            if (InputStream.class.isAssignableFrom(type)) {
                InputStream inputStream = rs.getBinaryStream(1);
                return var2_30;
            }
            if (Reader.class.isAssignableFrom(type)) {
                Reader reader = rs.getCharacterStream(1);
                return var2_30;
            }
            Constructor<T> constructor = null;
            try {
                constructor = type.getConstructor(new Class[0]);
            }
            catch (Exception columnCount) {
                // empty catch block
            }
            if (constructor == null) {
                return (T)rs.getObject(1);
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            ArrayList<String> fieldNames = new ArrayList<String>(columnCount);
            for (i = 1; i <= columnCount; ++i) {
                String attribute = StringUtils.toCamelCase((String)rsmd.getColumnLabel(i), (String)"_", (boolean)false);
                fieldNames.add(attribute);
            }
            try {
                T t = constructor.newInstance(new Object[0]);
                for (i = 1; i <= columnCount; ++i) {
                    ReadOnlySQLExecutor.setValue(t, (String)fieldNames.get(i - 1), rs, i);
                }
                return var2_30;
            }
            catch (Exception e) {
                throw new SQLExecutorException(e);
            }
        }
        Object t = resultGetter.getValue(rs, 1);
        return var2_30;
    }

    public static <T> void setValue(Object row, String fieldName, ResultSet rs, int columnIndex) throws Exception {
        ResultGetter resultGetter;
        Class type = ObjectUtils.getFieldType((Object)row, (String)fieldName, (boolean)false);
        Object value = type == null ? rs.getObject(columnIndex) : ((resultGetter = RESULT_GETTERS.get(type)) == null ? (Ref.class.isAssignableFrom(type) ? rs.getRef(columnIndex) : (Array.class.isAssignableFrom(type) ? rs.getArray(columnIndex) : (SQLXML.class.isAssignableFrom(type) ? rs.getSQLXML(columnIndex) : (Blob.class.isAssignableFrom(type) ? rs.getBlob(columnIndex) : (Clob.class.isAssignableFrom(type) ? rs.getClob(columnIndex) : (NClob.class.isAssignableFrom(type) ? rs.getNClob(columnIndex) : (RowId.class.isAssignableFrom(type) ? rs.getRowId(columnIndex) : (InputStream.class.isAssignableFrom(type) ? rs.getBinaryStream(columnIndex) : (Reader.class.isAssignableFrom(type) ? rs.getCharacterStream(columnIndex) : rs.getObject(columnIndex)))))))))) : resultGetter.getValue(rs, columnIndex));
        ObjectUtils.setValue((Object)row, (String)fieldName, (Object)value, (boolean)false);
    }

    static {
        ServiceLoader<ResultGetter> loader = ServiceLoader.load(ResultGetter.class);
        for (ResultGetter resultGetter : loader) {
            RESULT_GETTERS.put(resultGetter.getType(), resultGetter);
        }
    }
}

