/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.context;

import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.PropertiesLoaderUtils;
import cn.tenmg.flink.jobs.configuration.ConfigurationLoader;
import cn.tenmg.flink.jobs.exception.DataSourceNotFoundException;
import cn.tenmg.flink.jobs.exception.IllegalConfigurationException;
import cn.tenmg.flink.jobs.utils.ConfigurationUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkJobsContext {
    private static Logger log;
    public static final String CONFIG_SPLITER = ".";
    public static final String SMART_MODE_CONFIG_KEY = "flink.jobs.smart";
    private static final ThreadLocal<Map<Object, Object>> RESOURCES;
    private static final Map<String, Map<String, String>> DATASOURCES;
    private static final Map<String, Map<String, String>> DATASOURCE_CACHE;
    private static final Map<String, String> AUTO_DATASOURCE;
    private static final Map<String, String> TABLE_EXEC_CONFIGS;
    private static final String DEFAULT_STRATEGIES_PATH = "flink-jobs-context-loader.properties";
    private static final String CONTEXT_LOCATION_KEY = "flink.jobs.context";
    private static final String DEFAULT_CONTEXT_LOCATION = "flink-jobs-context.properties";
    private static final String CONFIG_LOCATION_KEY = "config.location";
    private static final String DATASOURCE_PREFIX = "datasource.";
    private static final String AUTO_DATASOURCE_PREFIX = "auto.datasource.";
    private static final String TABLE_API_CONFIG_PREFIX = "table.exec";
    private static final String DATA_SYNC_CONFIG_REGEX = "^data\\.sync\\.[^\\.]+\\.((from|to)_type|script|strategy)$";
    private static final String EXECUTION_ENVIRONMENT = "ExecutionEnvironment";
    private static final String CURRENT_CONFIGURATION = "CurrentConfiguration";
    private static final String IDENTIFIER = "identifier";
    private static Properties config;

    public static String getCurrentConfiguration() {
        return (String)FlinkJobsContext.get(CURRENT_CONFIGURATION);
    }

    public static StreamExecutionEnvironment getExecutionEnvironment() {
        StreamExecutionEnvironment env = (StreamExecutionEnvironment)FlinkJobsContext.get(EXECUTION_ENVIRONMENT);
        if (env == null) {
            env = StreamExecutionEnvironment.getExecutionEnvironment();
            FlinkJobsContext.put(EXECUTION_ENVIRONMENT, env);
        }
        return env;
    }

    public static StreamExecutionEnvironment getExecutionEnvironment(String configuration) {
        if (configuration == null) {
            return FlinkJobsContext.getExecutionEnvironment();
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)org.apache.flink.configuration.ConfigurationUtils.createConfiguration((Properties)FlinkJobsContext.loadConfiguration(new Properties(), configuration)));
        FlinkJobsContext.put(CURRENT_CONFIGURATION, configuration);
        FlinkJobsContext.put(EXECUTION_ENVIRONMENT, env);
        return env;
    }

    public static StreamTableEnvironment getOrCreateStreamTableEnvironment() {
        return FlinkJobsContext.getOrCreateStreamTableEnvironment(FlinkJobsContext.getExecutionEnvironment());
    }

    public static StreamTableEnvironment getOrCreateStreamTableEnvironment(StreamExecutionEnvironment env) {
        StreamTableEnvironment tableEnv = (StreamTableEnvironment)FlinkJobsContext.get(env);
        if (tableEnv == null) {
            tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
            TableConfig tableConfig = tableEnv.getConfig();
            Properties properties = new Properties();
            properties.putAll(FlinkJobsContext.getTableExecConfigs());
            FlinkJobsContext.loadConfiguration(properties, FlinkJobsContext.getCurrentConfiguration());
            tableConfig.addConfiguration(org.apache.flink.configuration.ConfigurationUtils.createConfiguration((Properties)properties));
            FlinkJobsContext.put(env, tableEnv);
            FlinkJobsContext.put(tableEnv, tableEnv.getCurrentCatalog());
        }
        return tableEnv;
    }

    public static String getDefaultCatalog(StreamTableEnvironment tableEnv) {
        String catalog = (String)FlinkJobsContext.get(tableEnv);
        if (catalog == null) {
            catalog = tableEnv.getCurrentCatalog();
            FlinkJobsContext.put(tableEnv, catalog);
        }
        return catalog;
    }

    public static String getProperty(String key) {
        return config.getProperty(key);
    }

    public static String getProperty(List<String> priorKeys) {
        return FlinkJobsContext.getProperty(priorKeys, null);
    }

    public static String getProperty(String key, String defaultValue) {
        return config.getProperty(key, defaultValue);
    }

    public static String getProperty(List<String> priorKeys, String defaultValue) {
        return ConfigurationUtils.getProperty(config, priorKeys, defaultValue);
    }

    public static String getDefaultJDBCDriver(String productName) {
        return FlinkJobsContext.getProperty("jdbc." + productName + CONFIG_SPLITER + "driver");
    }

    public static Map<Object, Object> getResources() {
        if (RESOURCES.get() == null) {
            return Collections.emptyMap();
        }
        return new HashMap<Object, Object>(RESOURCES.get());
    }

    public static void setResources(Map<Object, Object> newResources) {
        if (newResources == null || newResources.isEmpty()) {
            return;
        }
        FlinkJobsContext.ensureResourcesInitialized();
        RESOURCES.get().clear();
        RESOURCES.get().putAll(newResources);
    }

    public static Map<String, Map<String, String>> getDatasources() {
        return DATASOURCES;
    }

    @Deprecated
    public static String getConfigurationFile() {
        return config.getProperty(CONFIG_LOCATION_KEY, "flink-jobs.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getDatasource(String name) {
        Map<String, String> dataSource = DATASOURCES.get(name);
        if (dataSource == null) {
            if (AUTO_DATASOURCE.isEmpty()) {
                throw new DataSourceNotFoundException("DataSource named " + name + " not found, Please check the configuration");
            }
            dataSource = DATASOURCE_CACHE.get(name);
            if (dataSource == null) {
                Map<String, Map<String, String>> map = DATASOURCE_CACHE;
                synchronized (map) {
                    dataSource = DATASOURCE_CACHE.get(name);
                    if (dataSource == null) {
                        log.debug("Generated and cached the DataSource named " + name + " automatically");
                        dataSource = MapUtils.toHashMapBuilder(AUTO_DATASOURCE).build((Object)AUTO_DATASOURCE.get(IDENTIFIER), (Object)name);
                        dataSource.remove(IDENTIFIER);
                        DATASOURCE_CACHE.put(name, dataSource);
                    }
                }
            } else {
                log.debug("Get automatically generated DataSource named " + name + " from cache");
            }
        }
        return dataSource;
    }

    public static Map<String, String> getTableExecConfigs() {
        return TABLE_EXEC_CONFIGS;
    }

    public static Object get(Object key) {
        return FlinkJobsContext.getValue(key);
    }

    public static void put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            FlinkJobsContext.remove(key);
            return;
        }
        FlinkJobsContext.ensureResourcesInitialized();
        RESOURCES.get().put(key, value);
    }

    public static Object remove(Object key) {
        Map<Object, Object> perThreadResources = RESOURCES.get();
        return perThreadResources != null ? perThreadResources.remove(key) : null;
    }

    public Properties getConfig(String keyPrefix) {
        return null;
    }

    public static void remove() {
        RESOURCES.remove();
    }

    private static Object getValue(Object key) {
        Map<Object, Object> perThreadData = RESOURCES.get();
        return perThreadData != null ? perThreadData.get(key) : null;
    }

    private static void ensureResourcesInitialized() {
        if (RESOURCES.get() == null) {
            RESOURCES.set(new HashMap());
        }
    }

    private static Properties loadConfiguration(Properties properties, String configuration) {
        Map<String, String> config = ConfigurationUtils.load(configuration);
        if (config != null) {
            properties.putAll(config);
        }
        return properties;
    }

    static {
        ConfigurationLoader loader;
        log = LoggerFactory.getLogger(FlinkJobsContext.class);
        RESOURCES = new InheritableThreadLocalMap();
        DATASOURCES = new HashMap<String, Map<String, String>>();
        DATASOURCE_CACHE = new HashMap<String, Map<String, String>>();
        AUTO_DATASOURCE = new HashMap<String, String>();
        TABLE_EXEC_CONFIGS = new HashMap<String, String>();
        config = new Properties();
        config.putAll(System.getenv());
        config.putAll((Map<?, ?>)System.getProperties());
        PropertiesLoaderUtils.loadIgnoreException((Properties)config, (String)DEFAULT_STRATEGIES_PATH);
        String contextFile = FlinkJobsContext.getProperty(Arrays.asList("context.location", CONTEXT_LOCATION_KEY), DEFAULT_CONTEXT_LOCATION);
        try {
            PropertiesLoaderUtils.load((Properties)config, (String)contextFile);
        }
        catch (Exception e) {
            log.warn("An exception occurred while loading ".concat(contextFile) + " in classpath", (Throwable)e);
        }
        String loaderClassName = config.getProperty("flink.jobs.configuration-loader", "cn.tenmg.flink.jobs.configuration.loader.PropertiesFileConfigurationLoader");
        try {
            Class<?> cls = Class.forName(loaderClassName);
            loader = (ConfigurationLoader)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigurationException("Unable to find configuration loader " + loaderClassName, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalConfigurationException("Error occurred in instantiation configuration loader", e);
        }
        loader.load(config);
        boolean ignoreCase = Boolean.valueOf(FlinkJobsContext.getProperty(Arrays.asList("data.sync.timestamp.case_sensitive", "data.sync.timestamp.case-sensitive"), "true")) == false;
        int configSpliterLen = CONFIG_SPLITER.length();
        int datasourcePrefixLen = DATASOURCE_PREFIX.length();
        int autoDatasourcePrefixLen = AUTO_DATASOURCE_PREFIX.length();
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            String keyLowercase;
            String param;
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (key.startsWith(DATASOURCE_PREFIX)) {
                param = key.substring(datasourcePrefixLen);
                int index = param.indexOf(CONFIG_SPLITER);
                if (index <= 0) continue;
                String name = param.substring(0, index);
                param = param.substring(index + configSpliterLen);
                Map<String, String> dataSource = DATASOURCES.get(name);
                if (dataSource == null) {
                    dataSource = new LinkedHashMap<String, String>();
                    DATASOURCES.put(name, dataSource);
                }
                dataSource.put(param, value.toString());
                continue;
            }
            if (key.startsWith(AUTO_DATASOURCE_PREFIX)) {
                param = key.substring(autoDatasourcePrefixLen);
                AUTO_DATASOURCE.put(param, value.toString());
                continue;
            }
            if (key.startsWith(TABLE_API_CONFIG_PREFIX)) {
                TABLE_EXEC_CONFIGS.put(key, value.toString());
                continue;
            }
            if (!ignoreCase || !key.matches(DATA_SYNC_CONFIG_REGEX) || key.equals(keyLowercase = key.toLowerCase()) || config.containsKey(keyLowercase)) continue;
            config.put(keyLowercase, value);
        }
    }

    private static final class InheritableThreadLocalMap<T extends Map<Object, Object>>
    extends InheritableThreadLocal<Map<Object, Object>> {
        private InheritableThreadLocalMap() {
        }

        @Override
        protected Map<Object, Object> childValue(Map<Object, Object> parentValue) {
            if (parentValue != null) {
                return (Map)((HashMap)parentValue).clone();
            }
            return null;
        }
    }
}

