/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.datasource.filter;

import cn.tenmg.dsl.utils.MatchUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.datasource.DataSourceFilter;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractDataSourceFilter
implements DataSourceFilter {
    protected static final String PROPERTIES_SPLITOR = ",";
    protected static final String[] VERSION_IGNORE_CONNECTORS = new String[]{"hbase", "elasticsearch"};

    abstract String getKeyPrefix();

    @Override
    public void doFilter(Map<String, String> dataSource) {
        if (dataSource == null) {
            return;
        }
        String connector = dataSource.get("connector");
        String keyPrefix = this.getKeyPrefix();
        String property = FlinkJobsContext.getProperty(keyPrefix + connector);
        if (property == null) {
            property = this.getVersionIgnoreProperty(keyPrefix, connector);
        }
        if (StringUtils.isNotBlank((String)property)) {
            String[] properties = property.split(PROPERTIES_SPLITOR);
            Iterator<Map.Entry<String, String>> it = dataSource.entrySet().iterator();
            while (it.hasNext()) {
                if (!MatchUtils.matchesAny((String[])properties, (String)it.next().getKey())) continue;
                it.remove();
            }
        }
    }

    protected String getVersionIgnoreProperty(String keyPrefix, String connector) {
        for (int i = 0; i < VERSION_IGNORE_CONNECTORS.length; ++i) {
            String versionIgnoreConnector = VERSION_IGNORE_CONNECTORS[i];
            if (!connector.startsWith(versionIgnoreConnector)) continue;
            return FlinkJobsContext.getProperty(keyPrefix + versionIgnoreConnector);
        }
        return null;
    }
}

