/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.metadata.getter;

import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.metadata.getter.AbstractJDBCMetaDataGetter;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class StarrocksMetaDataGetter
extends AbstractJDBCMetaDataGetter {
    private static final boolean UK_AS_PK = Boolean.valueOf(FlinkJobsContext.getProperty(Arrays.asList("metadata.starrocks.unique_key_as_primary_key", "metadata.starrocks.unique-key-as-primary-key"), "true"));
    private static final boolean CAL_AS_SCM = Boolean.valueOf(FlinkJobsContext.getProperty(Arrays.asList("metadata.starrocks.catalog_as_schema", "metadata.starrocks.catalog-as-schema"), "true"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<String> getPrimaryKeys(Connection con, String catalog, String schema, String tableName) throws SQLException {
        HashSet<String> hashSet;
        StringBuilder sqlBuilder = new StringBuilder("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE COLUMN_KEY " + (UK_AS_PK ? "IN ('PRI','UNI')" : "= 'PRI'"));
        if (schema != null || CAL_AS_SCM && catalog != null) {
            sqlBuilder.append(" AND TABLE_SCHEMA = ?");
        }
        sqlBuilder.append(" AND TABLE_NAME = ? ORDER BY ORDINAL_POSITION");
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sqlBuilder.toString());
            int nextId = 1;
            if (schema != null) {
                ps.setString(nextId++, schema);
            } else if (CAL_AS_SCM && catalog != null) {
                ps.setString(nextId++, catalog);
            }
            ps.setString(nextId, tableName);
            rs = ps.executeQuery();
            HashSet<String> primaryKeys = new HashSet<String>();
            while (rs.next()) {
                primaryKeys.add(rs.getString("COLUMN_NAME"));
            }
            hashSet = primaryKeys;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close(ps);
            throw throwable;
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(ps);
        return hashSet;
    }
}

