/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sparktool.dao;

import cn.tenmg.sparktool.SparkDao;
import cn.tenmg.sparktool.sql.engine.SparkSQLEngine;
import cn.tenmg.sparktool.utils.SQLEngineUtils;
import cn.tenmg.sqltool.DSQLFactory;
import cn.tenmg.sqltool.dsql.NamedSQL;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class DSQLSparkDao
implements SparkDao {
    private static final long serialVersionUID = 4516839414204232733L;
    private DSQLFactory DSQLFactory;

    public DSQLSparkDao(DSQLFactory DSQLFactory2) {
        this.DSQLFactory = DSQLFactory2;
    }

    public static DSQLSparkDao build(DSQLFactory DSQLFactory2) {
        return new DSQLSparkDao(DSQLFactory2);
    }

    @Override
    public Dataset<Row> load(SparkSession sparkSession, Map<String, String> options, String dsql, Object ... params) {
        return this.load(sparkSession, options, this.DSQLFactory.parse(dsql, params));
    }

    @Override
    public Dataset<Row> load(SparkSession sparkSession, Map<String, String> options, String dsql, Map<String, Object> params) {
        return this.load(sparkSession, options, this.DSQLFactory.parse(dsql, params));
    }

    @Override
    public Dataset<Row> sql(SparkSession sparkSession, String dsql, Object ... params) {
        return this.sql(sparkSession, this.DSQLFactory.parse(dsql, params));
    }

    @Override
    public Dataset<Row> sql(SparkSession sparkSession, String dsql, Map<String, Object> params) {
        return this.sql(sparkSession, this.DSQLFactory.parse(dsql, params));
    }

    private Dataset<Row> load(SparkSession sparkSession, Map<String, String> options, NamedSQL namedSQL) {
        return sparkSession.sqlContext().read().options(options).option("query", SQLEngineUtils.getSqlEngine(options.get("url")).parse(namedSQL)).format("jdbc").load();
    }

    private Dataset<Row> sql(SparkSession sparkSession, NamedSQL namedSQL) {
        return sparkSession.sqlContext().sql(SparkSQLEngine.getInstance().parse(namedSQL));
    }
}

