/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sparktool.sql.engine;

import cn.tenmg.sparktool.sql.SQLEngine;
import cn.tenmg.sqltool.dsql.NamedSQL;
import cn.tenmg.sqltool.dsql.utils.DSQLUtils;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractSQLEngine
implements SQLEngine {
    private static final long serialVersionUID = -867998927447365357L;
    private static final char SINGLE_QUOTATION_MARK = '\'';

    abstract String parse(Date var1);

    @Override
    public String parse(NamedSQL namedSQL) {
        String source = namedSQL.getScript();
        HashMap params = namedSQL.getParams();
        if (params == null) {
            params = new HashMap();
        }
        if (StringUtils.isBlank((String)source)) {
            return source;
        }
        int len = source.length();
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isParam = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder paramName = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            if (isString) {
                if (DSQLUtils.isStringEnd((char)a, (char)b, (char)c)) {
                    isString = false;
                }
                sb.append(c);
            } else if (c == '\'') {
                isString = true;
                sb.append(c);
            } else if (isParam) {
                if (DSQLUtils.isParamChar((char)c)) {
                    paramName.append(c);
                } else {
                    isParam = false;
                    String name = paramName.toString();
                    this.parseParam(sb, name, params.get(name));
                    sb.append(c);
                }
            } else if (DSQLUtils.isParamBegin((char)b, (char)c)) {
                isParam = true;
                paramName.setLength(0);
                paramName.append(c);
                sb.setLength(sb.length() - 1);
            } else {
                sb.append(c);
            }
            a = b;
            b = c;
        }
        if (isParam) {
            String name = paramName.toString();
            this.parseParam(sb, name, params.get(name));
        }
        return sb.toString();
    }

    private void parseParam(StringBuilder sb, String name, Object value) {
        if (value == null) {
            AbstractSQLEngine.appendNull(sb);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (CollectionUtils.isEmpty((Collection)collection)) {
                AbstractSQLEngine.appendNull(sb);
            } else {
                boolean flag = false;
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    if (flag) {
                        sb.append(", ");
                    } else {
                        flag = true;
                    }
                    this.append(sb, it.next());
                }
            }
        } else if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            if (objects.length == 0) {
                AbstractSQLEngine.appendNull(sb);
            } else {
                for (int j = 0; j < objects.length; ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    this.append(sb, objects[j]);
                }
            }
        } else {
            this.append(sb, value);
        }
    }

    private void append(StringBuilder sb, Object value) {
        if (value instanceof String || value instanceof char[]) {
            AbstractSQLEngine.appendString(sb, (String)value);
        } else if (value instanceof Date) {
            AbstractSQLEngine.appendString(sb, this.parse((Date)value));
        } else if (value instanceof Calendar) {
            Date date = ((Calendar)value).getTime();
            if (date == null) {
                AbstractSQLEngine.appendNull(sb);
            } else {
                AbstractSQLEngine.appendString(sb, this.parse(date));
            }
        } else {
            sb.append(value.toString());
        }
    }

    private static final void appendNull(StringBuilder sb) {
        sb.append("NULL");
    }

    private static final void appendString(StringBuilder sb, String value) {
        sb.append("'").append(value).append("'");
    }
}

