/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sparktool.sql.engine;

import cn.tenmg.dsql.utils.DateUtils;
import cn.tenmg.sparktool.sql.engine.AbstractSQLEngine;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class SQLServerEngine
extends AbstractSQLEngine {
    private static final long serialVersionUID = 3853385545110009849L;
    private static final String CAST_FN = "CAST('%s' AS %s)";
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.S";
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATETIME = "DATETIME";
    private static final String TIME_PATTERN = "HH:mm:ss.S";
    private static final String TIME = "TIME";
    private static final SQLServerEngine INSTANCE = new SQLServerEngine();

    private SQLServerEngine() {
    }

    public static final SQLServerEngine getInstance() {
        return INSTANCE;
    }

    @Override
    String parse(Date date) {
        if (date instanceof Timestamp) {
            return String.format(CAST_FN, DateUtils.format((Object)date, (String)TIMESTAMP_PATTERN), DATETIME);
        }
        if (date instanceof Time) {
            return String.format(CAST_FN, DateUtils.format((Object)date, (String)TIME_PATTERN), TIME);
        }
        return String.format(CAST_FN, DateUtils.format((Object)date, (String)DATE_TIME_PATTERN), DATETIME);
    }
}

