/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.SQLPagingDialect;

public abstract class AbstractSQLPagingDialect
implements SQLPagingDialect {
    protected static final String SELECT = "SELECT";
    protected static final int SELECT_LEN = "SELECT".length();
    private static final String COUNT = " COUNT(*) ";
    private static final String COUNT_START = "SELECT COUNT(*) FROM (\n";
    private static final String COUNT_END = "\n) SQLTOOL";

    @Override
    public String countSql(String sql, SQLMetaData sqlMetaData) {
        int embedStartIndex = sqlMetaData.getEmbedStartIndex();
        int embedEndIndex = sqlMetaData.getEmbedEndIndex();
        int length = sqlMetaData.getLength();
        if (sqlMetaData.getLimitIndex() > 0 || sqlMetaData.getOffsetIndex() > 0 || sqlMetaData.getFetchIndex() > 0 || sqlMetaData.getGroupByIndex() > 0) {
            return AbstractSQLPagingDialect.wrapCountSql(sql, embedStartIndex, embedEndIndex, length);
        }
        int selectIndex = sqlMetaData.getSelectIndex();
        int fromIndex = sqlMetaData.getFromIndex();
        int orderByIndex = sqlMetaData.getOrderByIndex();
        if (selectIndex >= 0 && fromIndex > selectIndex) {
            if (orderByIndex > 0) {
                if (selectIndex > 0) {
                    return sql.substring(0, selectIndex).concat(sql.substring(selectIndex, selectIndex + SELECT_LEN)).concat(COUNT).concat(sql.substring(fromIndex, orderByIndex));
                }
                return sql.substring(selectIndex, selectIndex + SELECT_LEN).concat(COUNT).concat(sql.substring(fromIndex, orderByIndex));
            }
            return sql.substring(0, selectIndex).concat(sql.substring(selectIndex, selectIndex + SELECT_LEN)).concat(COUNT).concat(sql.substring(fromIndex));
        }
        return AbstractSQLPagingDialect.wrapCountSql(sql, embedStartIndex, embedEndIndex, length);
    }

    private static String wrapCountSql(String sql, int embedStartIndex, int embedEndIndex, int length) {
        sql = embedStartIndex > 0 ? (embedEndIndex < length ? sql.substring(0, embedStartIndex).concat(COUNT_START).concat(sql.substring(embedStartIndex, embedEndIndex)).concat(COUNT_END).concat(sql.substring(embedEndIndex)) : sql.substring(0, embedStartIndex).concat(COUNT_START).concat(sql.substring(embedStartIndex)).concat(COUNT_END)) : (embedEndIndex < length ? COUNT_START.concat(sql.substring(0, embedEndIndex)).concat(COUNT_END).concat(sql.substring(embedEndIndex)) : COUNT_START.concat(sql).concat(COUNT_END));
        return sql;
    }
}

