/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.dialect.AbstractSQLPagingDialect;
import cn.tenmg.sql.paging.utils.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

public class SQLServerPagingDialect
extends AbstractSQLPagingDialect {
    private static final String SQLTOOL_RN = " 1 RN__,";
    private static final String PAGE_WRAP_START = "SELECT %s FROM (\n";
    private static final String SUBQUERY_START = "SELECT 1 RN__,SQLTOOL.* FROM (\n";
    private static final String SUBQUERY_END = "\n) SQLTOOL";
    private static final String ORDER_BY = "\nORDER BY RN__";
    private static final String PAGE_WRAP_END = " OFFSET %d ROW FETCH NEXT %d ROW ONLY";
    private static final SQLServerPagingDialect INSTANCE = new SQLServerPagingDialect();

    public static final SQLServerPagingDialect getInstance() {
        return INSTANCE;
    }

    protected SQLServerPagingDialect() {
    }

    @Override
    public String pageSql(Connection con, String sql, Map<String, ?> params, SQLMetaData sqlMetaData, int pageSize, long currentPage) throws SQLException {
        int selectIndex = sqlMetaData.getSelectIndex();
        if (selectIndex < 0) {
            return sql;
        }
        int offsetIndex = sqlMetaData.getOffsetIndex();
        int length = sqlMetaData.getLength();
        int embedStartIndex = sqlMetaData.getEmbedStartIndex();
        int embedEndIndex = sqlMetaData.getEmbedEndIndex();
        if (offsetIndex > 0) {
            String pageStart = SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, sql, params, sqlMetaData));
            if (embedStartIndex > 0) {
                if (embedEndIndex < length) {
                    return sql.substring(0, embedStartIndex).concat(pageStart).concat(SUBQUERY_START).concat(sql.substring(embedStartIndex, embedEndIndex)).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
                }
                return sql.substring(0, embedStartIndex).concat(pageStart).concat(SUBQUERY_START).concat(sql.substring(embedStartIndex)).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
            }
            if (embedEndIndex < length) {
                return pageStart.concat(SUBQUERY_START).concat(sql.substring(0, embedEndIndex)).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
            }
            return pageStart.concat(SUBQUERY_START).concat(sql).concat(SUBQUERY_END).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
        }
        int orderByIndex = sqlMetaData.getOrderByIndex();
        if (orderByIndex > 0) {
            if (embedEndIndex < length) {
                return sql.substring(0, embedEndIndex).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(sql.substring(embedEndIndex));
            }
            return sql.concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage));
        }
        String pageStart = SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, sql, params, sqlMetaData));
        int selectEndIndex = selectIndex + SELECT_LEN;
        if (embedStartIndex > 0) {
            if (embedEndIndex < length) {
                return sql.substring(0, embedStartIndex).concat(pageStart).concat(sql.substring(embedStartIndex, selectIndex)).concat(sql.substring(selectIndex, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex, embedEndIndex)).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
            }
            return sql.substring(0, embedStartIndex).concat(pageStart).concat(sql.substring(embedStartIndex, selectIndex)).concat(sql.substring(selectIndex, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex)).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
        }
        if (embedEndIndex < length) {
            return pageStart.concat(sql.substring(0, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex, embedEndIndex)).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END).concat(sql.substring(embedEndIndex));
        }
        return pageStart.concat(sql.substring(0, selectEndIndex)).concat(SQLTOOL_RN).concat(sql.substring(selectEndIndex)).concat(ORDER_BY).concat(SQLServerPagingDialect.pageEnd(pageSize, currentPage)).concat(SUBQUERY_END);
    }

    private static String pageStart(String[] columnLabels) {
        return String.format(PAGE_WRAP_START, String.join((CharSequence)", ", columnLabels));
    }

    private static String pageEnd(int pageSize, long currentPage) {
        return String.format(PAGE_WRAP_END, (currentPage - 1L) * (long)pageSize, pageSize);
    }
}

