/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.dialect.AbstractSQLPagingDialect;
import java.sql.Connection;
import java.util.Map;

public class PostgreSQLPagingDialect
extends AbstractSQLPagingDialect {
    private static final String PAGE_WRAP_START = "SELECT * FROM (\n";
    private static final String PAGE_WRAP_END = "\n) SQLTOOL";
    private static final String LIMIT = " LIMIT %d OFFSET %d";
    private static final PostgreSQLPagingDialect INSTANCE = new PostgreSQLPagingDialect();

    public static final PostgreSQLPagingDialect getInstance() {
        return INSTANCE;
    }

    protected PostgreSQLPagingDialect() {
    }

    @Override
    public String pageSql(Connection con, String namedSql, Map<String, ?> params, SQLMetaData sqlMetaData, int pageSize, long currentPage) {
        int selectIndex = sqlMetaData.getSelectIndex();
        if (selectIndex < 0) {
            return namedSql;
        }
        int length = sqlMetaData.getLength();
        int embedEndIndex = sqlMetaData.getEmbedEndIndex();
        if (sqlMetaData.getLimitIndex() >= 0) {
            int embedStartIndex = sqlMetaData.getEmbedStartIndex();
            if (embedStartIndex > 0) {
                if (embedEndIndex < length) {
                    return namedSql.substring(0, embedStartIndex).concat(PAGE_WRAP_START).concat(namedSql.substring(embedStartIndex, embedEndIndex)).concat(PostgreSQLPagingDialect.pageEnd(pageSize, currentPage)).concat(namedSql.substring(embedEndIndex));
                }
                return namedSql.substring(0, embedStartIndex).concat(PAGE_WRAP_START).concat(namedSql.substring(embedStartIndex)).concat(PostgreSQLPagingDialect.pageEnd(pageSize, currentPage));
            }
            if (embedEndIndex < length) {
                return PAGE_WRAP_START.concat(namedSql.substring(0, embedEndIndex)).concat(PostgreSQLPagingDialect.pageEnd(pageSize, currentPage)).concat(namedSql.substring(embedEndIndex));
            }
            return PAGE_WRAP_START.concat(namedSql).concat(PostgreSQLPagingDialect.pageEnd(pageSize, currentPage));
        }
        if (embedEndIndex < length) {
            return namedSql.substring(0, embedEndIndex).concat(PostgreSQLPagingDialect.generateLimit(pageSize, currentPage)).concat(namedSql.substring(embedEndIndex));
        }
        return namedSql.concat(PostgreSQLPagingDialect.generateLimit(pageSize, currentPage));
    }

    private static String pageEnd(int pageSize, long currentPage) {
        return PAGE_WRAP_END.concat(PostgreSQLPagingDialect.generateLimit(pageSize, currentPage));
    }

    private static String generateLimit(int pageSize, long currentPage) {
        return String.format(LIMIT, pageSize, (currentPage - 1L) * (long)pageSize);
    }
}

