/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.SQLPagingDialect;

public abstract class AbstractSQLPagingDialect
implements SQLPagingDialect {
    protected static final String SELECT = "SELECT";
    protected static final int SELECT_LEN = "SELECT".length();
    private static final String COUNT = " COUNT(*) ";
    private static final String COUNT_START = "SELECT COUNT(*) FROM (\n";
    private static final String COUNT_END = "\n) SQLTOOL";

    @Override
    public String countSql(String namedSql, SQLMetaData sqlMetaData) {
        int embedStartIndex = sqlMetaData.getEmbedStartIndex();
        int embedEndIndex = sqlMetaData.getEmbedEndIndex();
        int length = sqlMetaData.getLength();
        if (sqlMetaData.getLimitIndex() > 0 || sqlMetaData.getOffsetIndex() > 0 || sqlMetaData.getFetchIndex() > 0 || sqlMetaData.getGroupByIndex() > 0) {
            return AbstractSQLPagingDialect.wrapCountSql(namedSql, embedStartIndex, embedEndIndex, length);
        }
        int selectIndex = sqlMetaData.getSelectIndex();
        int fromIndex = sqlMetaData.getFromIndex();
        int orderByIndex = sqlMetaData.getOrderByIndex();
        if (selectIndex >= 0 && fromIndex > selectIndex) {
            if (orderByIndex > 0) {
                if (selectIndex > 0) {
                    return namedSql.substring(0, selectIndex).concat(namedSql.substring(selectIndex, selectIndex + SELECT_LEN)).concat(COUNT).concat(namedSql.substring(fromIndex, orderByIndex));
                }
                return namedSql.substring(selectIndex, selectIndex + SELECT_LEN).concat(COUNT).concat(namedSql.substring(fromIndex, orderByIndex));
            }
            return namedSql.substring(0, selectIndex).concat(namedSql.substring(selectIndex, selectIndex + SELECT_LEN)).concat(COUNT).concat(namedSql.substring(fromIndex));
        }
        return AbstractSQLPagingDialect.wrapCountSql(namedSql, embedStartIndex, embedEndIndex, length);
    }

    private static String wrapCountSql(String namedSql, int embedStartIndex, int embedEndIndex, int length) {
        namedSql = embedStartIndex > 0 ? (embedEndIndex < length ? namedSql.substring(0, embedStartIndex).concat(COUNT_START).concat(namedSql.substring(embedStartIndex, embedEndIndex)).concat(COUNT_END).concat(namedSql.substring(embedEndIndex)) : namedSql.substring(0, embedStartIndex).concat(COUNT_START).concat(namedSql.substring(embedStartIndex)).concat(COUNT_END)) : (embedEndIndex < length ? COUNT_START.concat(namedSql.substring(0, embedEndIndex)).concat(COUNT_END).concat(namedSql.substring(embedEndIndex)) : COUNT_START.concat(namedSql).concat(COUNT_END));
        return namedSql;
    }
}

