/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.utils;

import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.SetUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.utils.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SQLUtils {
    public static final char BACKSLASH = '\\';
    public static final char BLANK_SPACE = ' ';
    public static final char LEFT_BRACKET = '(';
    public static final char RIGHT_BRACKET = ')';
    public static final char COMMA = ',';
    public static final char SINGLE_QUOTATION_MARK = '\'';
    public static final char PARAM_MARK = '?';
    public static final char[] LINE_SEPARATOR = new char[]{'\r', '\n'};
    private static final String WITH = "WITH";
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final String WHERE = "WHERE";
    private static final String GROUP = "GROUP";
    private static final String BY = "BY";
    private static final String HAVING = "HAVING";
    private static final String ORDER = "ORDER";
    private static final String LIMIT = "LIMIT";
    private static final String OFFSET = "OFFSET";
    private static final String FETCH = "FETCH";
    private static final String UNION = "UNION";
    private static final String AND = "AND";
    private static final String BLANK_SPACE_AND = " AND";
    private static final String IMPOSSIBLE = " 1=0";
    private static final String WHERE_IMPOSSIBLE = "WHERE 1=0";
    private static final String BLANK_SPACE_WHERE_IMPOSSIBLE = " WHERE 1=0";
    private static final int WITH_LEN = "WITH".length();
    private static final int SELECT_LEN = "SELECT".length();
    private static final int FROM_LEN = "FROM".length();
    private static final int WHERE_LEN = "WHERE".length();
    private static final int GROUP_LEN = "GROUP".length();
    private static final int HAVING_LEN = "HAVING".length();
    private static final int ORDER_LEN = "ORDER".length();
    private static final int LIMIT_LEN = "LIMIT".length();
    private static final int OFFSET_LEN = "OFFSET".length();
    private static final int FETCH_LEN = "FETCH".length();
    private static final Set<String> WITH_SQL_TO_NO_RESULT_SQL_PRODUCTS = SetUtils.newHashSet((Object[])new String[]{"Microsoft SQL Server"});

    public static SQLMetaData getSQLMetaData(String sql) {
        SQLMetaData sqlMetaData = new SQLMetaData();
        int deep = 0;
        int len = sql.length();
        sqlMetaData.setLength(len);
        int backslashes = 0;
        int groupOrOrderIndex = -1;
        char a = ' ';
        char b = ' ';
        boolean isWith = false;
        boolean isString = false;
        boolean isSinglelineComment = false;
        boolean isMiltilineComment = false;
        StringBuilder wordBefore = new StringBuilder();
        StringBuilder currentWord = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            if (isWith) {
                if (isString) {
                    if (c == '\\') {
                        ++backslashes;
                    } else if (DSLUtils.isStringEnd((char)a, (char)b, (char)c, (int)backslashes)) {
                        isString = false;
                    }
                } else if (c == '\'') {
                    isString = true;
                    wordBefore.setLength(0);
                    currentWord.setLength(0);
                } else if (c == '(') {
                    ++deep;
                    currentWord.setLength(0);
                } else if (c == ')') {
                    --deep;
                    currentWord.setLength(0);
                } else if (c <= ' ') {
                    if (deep == 0 && SELECT.equalsIgnoreCase(currentWord.toString())) {
                        sqlMetaData.setSelectIndex(i - SELECT_LEN);
                        isWith = false;
                    }
                    currentWord.setLength(0);
                } else {
                    currentWord.append(c);
                }
            } else if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd((char)a, (char)b, (char)c, (int)backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
            } else if (c == '\'') {
                wordBefore.setLength(0);
                currentWord.setLength(0);
                isString = true;
            } else if (isSinglelineComment) {
                if (c == '\n') {
                    isSinglelineComment = false;
                }
            } else if (isMiltilineComment) {
                if (DSLUtils.isMiltilineCommentEnd((char)b, (char)c)) {
                    isMiltilineComment = false;
                }
            } else if (DSLUtils.isSinglelineCommentBegin((char)b, (char)c)) {
                wordBefore.setLength(0);
                currentWord.setLength(0);
                isSinglelineComment = true;
            } else if (DSLUtils.isMiltilineCommentBegin((char)b, (char)c)) {
                wordBefore.setLength(0);
                currentWord.setLength(0);
                isMiltilineComment = true;
            } else if (c == '(') {
                ++deep;
                wordBefore.setLength(0);
                currentWord.setLength(0);
            } else if (c == ')') {
                --deep;
                wordBefore.setLength(0);
                currentWord.setLength(0);
            } else if (c <= ' ') {
                if (deep == 0) {
                    String cw = currentWord.toString();
                    if (WITH.equalsIgnoreCase(cw)) {
                        sqlMetaData.setWithIndex(i - WITH_LEN);
                        isWith = true;
                    } else if (SELECT.equalsIgnoreCase(cw)) {
                        if (sqlMetaData.getSelectIndex() < 0) {
                            sqlMetaData.setSelectIndex(i - SELECT_LEN);
                        }
                    } else if (FROM.equalsIgnoreCase(cw)) {
                        if (sqlMetaData.getFromIndex() < 0) {
                            sqlMetaData.setFromIndex(i - FROM_LEN);
                        }
                    } else if (WHERE.equalsIgnoreCase(cw)) {
                        sqlMetaData.setWhereIndex(i - WHERE_LEN);
                    } else if (GROUP.equalsIgnoreCase(cw)) {
                        groupOrOrderIndex = i - GROUP_LEN;
                    } else if (BY.equalsIgnoreCase(cw)) {
                        String wb = wordBefore.toString();
                        if (GROUP.equalsIgnoreCase(wb)) {
                            sqlMetaData.setGroupByIndex(groupOrOrderIndex);
                        } else if (ORDER.equalsIgnoreCase(wb)) {
                            sqlMetaData.setOrderByIndex(groupOrOrderIndex);
                        }
                    } else if (ORDER.equalsIgnoreCase(cw)) {
                        groupOrOrderIndex = i - ORDER_LEN;
                    } else if (HAVING.equalsIgnoreCase(cw)) {
                        sqlMetaData.setHavingIndex(i - HAVING_LEN);
                    } else if (LIMIT.equalsIgnoreCase(cw)) {
                        sqlMetaData.setLimitIndex(i - LIMIT_LEN);
                    } else if (OFFSET.equalsIgnoreCase(cw)) {
                        sqlMetaData.setOffsetIndex(i - OFFSET_LEN);
                    } else if (FETCH.equalsIgnoreCase(cw)) {
                        sqlMetaData.setFetchIndex(i - FETCH_LEN);
                    } else if (UNION.equalsIgnoreCase(cw)) {
                        sqlMetaData.setUnion(true);
                    }
                    wordBefore.setLength(0);
                    wordBefore.append((CharSequence)currentWord);
                }
                currentWord.setLength(0);
            } else {
                currentWord.append(c);
            }
            a = b;
            b = c;
        }
        return sqlMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getColumnLabels(Connection con, String namedSQL, Map<String, ?> params, SQLMetaData sqlMetaData) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String[] columnLabels = null;
        try {
            ResultSetMetaData rsmd;
            if (sqlMetaData.getWithIndex() >= 0 && WITH_SQL_TO_NO_RESULT_SQL_PRODUCTS.contains(con.getMetaData().getDatabaseProductName())) {
                namedSQL = SQLUtils.toNoResultSQL(namedSQL, params, sqlMetaData);
                Script sql = DSLUtils.toScript((String)namedSQL, params, (ParamsParser)JDBCParamsParser.getInstance());
                ps = con.prepareStatement(sql.getValue());
                JDBCUtils.setParams(ps, (List)sql.getParams());
                rs = ps.executeQuery();
                rsmd = rs.getMetaData();
            } else {
                int firstStatmentIndexAfterGroupBy = SQLUtils.firstStatmentIndexAfterGroupBy(sqlMetaData);
                if (firstStatmentIndexAfterGroupBy > 0) {
                    namedSQL = namedSQL.substring(0, firstStatmentIndexAfterGroupBy);
                }
                Script sql = DSLUtils.toScript((String)namedSQL, params, (ParamsParser)JDBCParamsParser.getInstance());
                ps = con.prepareStatement(sql.getValue());
                JDBCUtils.setParams(ps, (List)sql.getParams());
                rsmd = ps.getMetaData();
            }
            int columnCount = rsmd.getColumnCount();
            columnLabels = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnLabels[i - 1] = rsmd.getColumnLabel(i);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close(ps);
            throw throwable;
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(ps);
        return columnLabels;
    }

    private static String toNoResultSQL(String namedSQL, Map<String, ?> params, SQLMetaData sqlMetaData) {
        int whereIndex = sqlMetaData.getWhereIndex();
        int limitIndex = sqlMetaData.getLimitIndex();
        int firstStatmentIndexAfterWhere = SQLUtils.firstStatmentIndexAfterWhere(sqlMetaData);
        if (limitIndex < 0) {
            limitIndex = sqlMetaData.getOffsetIndex();
        }
        if (limitIndex < 0) {
            limitIndex = sqlMetaData.getFetchIndex();
        }
        if (whereIndex > 0) {
            if (firstStatmentIndexAfterWhere > 0) {
                if (limitIndex > firstStatmentIndexAfterWhere) {
                    return StringUtils.concat((String[])new String[]{namedSQL.substring(0, firstStatmentIndexAfterWhere), AND, IMPOSSIBLE, namedSQL.substring(firstStatmentIndexAfterWhere, limitIndex)});
                }
                return StringUtils.concat((String[])new String[]{namedSQL.substring(0, firstStatmentIndexAfterWhere), AND, IMPOSSIBLE, namedSQL.substring(firstStatmentIndexAfterWhere)});
            }
            if (limitIndex > firstStatmentIndexAfterWhere) {
                return StringUtils.concat((String[])new String[]{namedSQL.substring(0, limitIndex), BLANK_SPACE_AND, IMPOSSIBLE});
            }
            return StringUtils.concat((String[])new String[]{namedSQL, BLANK_SPACE_AND, IMPOSSIBLE});
        }
        if (firstStatmentIndexAfterWhere > 0) {
            if (limitIndex > firstStatmentIndexAfterWhere) {
                return StringUtils.concat((String[])new String[]{namedSQL.substring(0, firstStatmentIndexAfterWhere), WHERE_IMPOSSIBLE, namedSQL.substring(firstStatmentIndexAfterWhere, limitIndex)});
            }
            return StringUtils.concat((String[])new String[]{namedSQL.substring(0, firstStatmentIndexAfterWhere), WHERE_IMPOSSIBLE, namedSQL.substring(firstStatmentIndexAfterWhere)});
        }
        if (limitIndex > firstStatmentIndexAfterWhere) {
            return StringUtils.concat((String[])new String[]{namedSQL.substring(0, limitIndex), BLANK_SPACE_WHERE_IMPOSSIBLE});
        }
        return StringUtils.concat((String[])new String[]{namedSQL, BLANK_SPACE_WHERE_IMPOSSIBLE});
    }

    private static int firstStatmentIndexAfterWhere(SQLMetaData sqlMetaData) {
        int index = sqlMetaData.getGroupByIndex();
        if (index < 0) {
            index = sqlMetaData.getHavingIndex();
        }
        if (index < 0) {
            index = sqlMetaData.getOrderByIndex();
        }
        return index;
    }

    private static int firstStatmentIndexAfterGroupBy(SQLMetaData sqlMetaData) {
        int index = sqlMetaData.getHavingIndex();
        if (index < 0) {
            index = sqlMetaData.getOrderByIndex();
        }
        if (index < 0) {
            index = sqlMetaData.getLimitIndex();
        }
        if (index < 0) {
            index = sqlMetaData.getOffsetIndex();
        }
        if (index < 0) {
            index = sqlMetaData.getFetchIndex();
        }
        return index;
    }
}

