/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.utils;

import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.utils.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class SQLUtils {
    public static final char BACKSLASH = '\\';
    public static final char BLANK_SPACE = ' ';
    public static final char LEFT_BRACKET = '(';
    public static final char RIGHT_BRACKET = ')';
    public static final char COMMA = ',';
    public static final char SINGLE_QUOTATION_MARK = '\'';
    public static final char PARAM_MARK = '?';
    public static final char[] LINE_SEPARATOR = new char[]{'\r', '\n'};
    private static final String WITH = "WITH";
    private static final String SELECT = "SELECT";
    private static final String FROM = "FROM";
    private static final String FROM_REVERSE = "MORF";
    private static final String ON_REVERSE = "NO";
    private static final String WHERE_REVERSE = "EREHW";
    private static final String GROUP_REVERSE = "PUORG";
    private static final String ORDER_REVERSE = "REDRO";
    private static final String BY_REVERSE = "YB";
    private static final String LIMIT_REVERSE = "TIMIL";
    private static final String OFFSET_REVERSE = "TESFFO";
    private static final String FETCH_REVERSE = "HCTEF";
    private static final String SELECT_ALL = "SELECT * FROM (\n";
    private static final String ALIAS = "\n) SQLTOOL";
    private static final String WHERE_IMPOSSIBLE = "\nWHERE 1=0";
    private static final int WITH_LEN = "WITH".length();
    private static final int SELECT_LEN = "SELECT".length();
    private static final int FROM_LEN = "FROM".length();

    public static SQLMetaData getSQLMetaData(String sql) {
        SQLMetaData sqlMetaData = new SQLMetaData();
        sqlMetaData.setLength(sql.length());
        SQLUtils.rightAnalysis(sql, sqlMetaData);
        SQLUtils.leftAnalysis(sql, sqlMetaData);
        return sqlMetaData;
    }

    public static final String[] getColumnLabels(Connection con, String namedSQL, Map<String, ?> params, SQLMetaData sqlMetaData) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String[] columnLabels = null;
        try {
            int length = sqlMetaData.getLength();
            int embedStartIndex = sqlMetaData.getEmbedStartIndex();
            int embedEndIndex = sqlMetaData.getEmbedEndIndex();
            String script = embedStartIndex > 0 ? (embedEndIndex < length ? namedSQL.substring(0, embedStartIndex).concat(SELECT_ALL).concat(namedSQL.substring(embedStartIndex, embedEndIndex)).concat(ALIAS).concat(WHERE_IMPOSSIBLE).concat(namedSQL.substring(embedEndIndex)) : namedSQL.substring(0, embedStartIndex).concat(SELECT_ALL).concat(namedSQL.substring(embedStartIndex)).concat(ALIAS).concat(WHERE_IMPOSSIBLE)) : (embedEndIndex < length ? SELECT_ALL.concat(namedSQL.substring(0, embedEndIndex)).concat(ALIAS).concat(WHERE_IMPOSSIBLE).concat(namedSQL.substring(embedEndIndex)) : SELECT_ALL.concat(namedSQL).concat(ALIAS).concat(WHERE_IMPOSSIBLE));
            Script SQL = DSLUtils.toScript((String)script, params, (ParamsParser)JDBCParamsParser.getInstance());
            ps = con.prepareStatement(SQL.getValue());
            JDBCUtils.setParams(ps, (List)SQL.getParams());
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            columnLabels = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnLabels[i - 1] = rsmd.getColumnLabel(i);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(ps);
                throw throwable;
            }
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(ps);
        return columnLabels;
    }

    private static void rightAnalysis(String sql, SQLMetaData sqlMetaData) {
        int length = sqlMetaData.getLength();
        int i = length - 1;
        char c = sql.charAt(i);
        boolean isString = false;
        int deep = 0;
        int[] lineSplitorIndexs = new int[]{length, length};
        StringBuilder sba = new StringBuilder();
        StringBuilder sbb = new StringBuilder();
        while (i > 0 && c <= ' ') {
            SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
            c = sql.charAt(--i);
        }
        SQLUtils.setEmbedEndIndex(sqlMetaData, lineSplitorIndexs[0], lineSplitorIndexs[1]);
        while (i > 0) {
            if (isString) {
                if (i <= 2) break;
                char b = sql.charAt(--i);
                if (c == '\'' && b != '\\') {
                    isString = false;
                }
                c = b;
                continue;
            }
            if (c == '\'') {
                isString = true;
                c = sql.charAt(--i);
                continue;
            }
            if (c == ')') {
                ++deep;
                sba.setLength(0);
                sba.setLength(0);
            } else if (c == '(') {
                --deep;
                sba.setLength(0);
                sba.setLength(0);
            } else if (deep == 0) {
                if (c == ',') {
                    sba.setLength(0);
                    sba.setLength(0);
                } else if (c <= ' ') {
                    String sa = sba.toString();
                    String sb = sbb.toString();
                    if (BY_REVERSE.equalsIgnoreCase(sa)) {
                        if (GROUP_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setGroupByIndex(i + 1);
                            break;
                        }
                        if (ORDER_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setOrderByIndex(i + 1);
                        }
                    } else if (LIMIT_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setLimitIndex(i + 1);
                    } else if (FETCH_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setFetchIndex(i + 1);
                    } else if (OFFSET_REVERSE.equalsIgnoreCase(sb)) {
                        sqlMetaData.setOffsetIndex(i + 1);
                    } else {
                        if (WHERE_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setWhereIndex(i + 1);
                            break;
                        }
                        if (ON_REVERSE.equalsIgnoreCase(sb)) break;
                        if (FROM_REVERSE.equalsIgnoreCase(sb)) {
                            sqlMetaData.setFromIndex(i + 1);
                            break;
                        }
                    }
                    sba = sbb;
                    sbb = new StringBuilder();
                } else {
                    sbb.append(c);
                }
            }
            c = sql.charAt(--i);
        }
    }

    private static void leftAnalysis(String sql, SQLMetaData sqlMetaData) {
        int i = 0;
        int deep = 0;
        int max = sqlMetaData.getLength();
        int fromIndex = sqlMetaData.getFromIndex();
        int whereIndex = sqlMetaData.getWhereIndex();
        if (whereIndex > 0) {
            max = whereIndex;
        } else if (fromIndex > 0) {
            max = fromIndex;
        }
        int backslashes = 0;
        int[] lineSplitorIndexs = new int[]{0, 0};
        char[] charsBefore = new char[]{' ', ' '};
        boolean isString = false;
        boolean isWith = false;
        StringBuilder sb = new StringBuilder();
        while (i < max) {
            String s;
            char c = sql.charAt(i);
            if (isWith) {
                if (isString) {
                    if (c == '\\') {
                        ++backslashes;
                    } else if (DSLUtils.isStringEnd((char)charsBefore[0], (char)charsBefore[1], (char)c, (int)backslashes)) {
                        isString = false;
                    }
                    i = SQLUtils.stepForward(charsBefore, c, i);
                    continue;
                }
                if (c == '\'') {
                    isString = true;
                    i = SQLUtils.stepForward(charsBefore, c, i);
                    continue;
                }
                if (c == '(') {
                    ++deep;
                    sb.setLength(0);
                } else if (c == ')') {
                    --deep;
                    sb.setLength(0);
                } else if (c <= ' ') {
                    if (deep == 0) {
                        SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
                        s = sb.toString();
                        if (SELECT.equalsIgnoreCase(s)) {
                            sqlMetaData.setSelectIndex(i - SELECT_LEN);
                            isWith = false;
                        }
                    }
                    sb.setLength(0);
                } else {
                    sb.append(c);
                }
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd((char)charsBefore[0], (char)charsBefore[1], (char)c, (int)backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (c == '\'') {
                isString = true;
                i = SQLUtils.stepForward(charsBefore, c, i);
                continue;
            }
            if (c == '(') {
                ++deep;
                sb.setLength(0);
            } else if (c == ')') {
                --deep;
                sb.setLength(0);
            } else if (c <= ' ') {
                if (deep == 0) {
                    if (sqlMetaData.getSelectIndex() < 0) {
                        SQLUtils.decideLineSplitorIndex(lineSplitorIndexs, c, i);
                    }
                    if (SELECT.equalsIgnoreCase(s = sb.toString())) {
                        sqlMetaData.setSelectIndex(i - SELECT_LEN);
                    } else if (FROM.equalsIgnoreCase(s)) {
                        sqlMetaData.setFromIndex(i - FROM_LEN);
                    } else if (WITH.equalsIgnoreCase(s)) {
                        sqlMetaData.setWithIndex(i - WITH_LEN);
                        isWith = true;
                    }
                }
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            i = SQLUtils.stepForward(charsBefore, c, i);
        }
        SQLUtils.setEmbedStartIndex(sqlMetaData, lineSplitorIndexs[0], lineSplitorIndexs[1]);
    }

    private static int stepForward(char[] charsBefore, char c, int i) {
        charsBefore[0] = charsBefore[1];
        charsBefore[1] = c;
        return ++i;
    }

    private static void decideLineSplitorIndex(int[] lineSplitorIndexs, char c, int i) {
        if (c == LINE_SEPARATOR[1]) {
            lineSplitorIndexs[1] = i;
        } else if (c == LINE_SEPARATOR[0]) {
            lineSplitorIndexs[0] = i;
        }
    }

    private static void setEmbedStartIndex(SQLMetaData sqlMetaData, int r, int n) {
        int withIndex = sqlMetaData.getWithIndex();
        int selectIndex = sqlMetaData.getSelectIndex();
        if (selectIndex > 0) {
            if (withIndex >= 0 && selectIndex > withIndex) {
                sqlMetaData.setEmbedStartIndex(selectIndex);
            } else if (r < n && n < selectIndex) {
                sqlMetaData.setEmbedStartIndex(n + 1);
            } else if (r > n && r < selectIndex) {
                sqlMetaData.setEmbedStartIndex(r + 1);
            } else {
                sqlMetaData.setEmbedStartIndex(selectIndex);
            }
        } else {
            sqlMetaData.setEmbedStartIndex(0);
        }
    }

    private static void setEmbedEndIndex(SQLMetaData sqlMetaData, int r, int n) {
        if (r < n) {
            sqlMetaData.setEmbedEndIndex(r);
        } else if (r > n) {
            sqlMetaData.setEmbedEndIndex(n);
        } else {
            sqlMetaData.setEmbedEndIndex(sqlMetaData.getLength());
        }
    }
}

