/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.dsl.utils.PropertiesLoaderUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.SQLPagingDialect;
import java.util.Properties;

public abstract class AbstractSQLPagingDialect
implements SQLPagingDialect {
    protected static final String SELECT = "SELECT";
    protected static final String COUNT;
    protected static final String COUNT_REGEX = "[\\s]*[C|c][O|o][U|u][N|n][T|t]\\([\\S]+\\)[\\s]*";
    protected static final String COUNT_START;
    protected static final String COUNT_END = ") SQL_PAGING";
    protected static final int SELECT_LEN;
    protected static final Properties config;

    @Override
    public String countSql(String namedSql, SQLMetaData sqlMetaData) {
        int selectIndex = sqlMetaData.getSelectIndex();
        int orderByIndex = sqlMetaData.getOrderByIndex();
        int limitIndex = sqlMetaData.getLimitIndex();
        if (limitIndex > 0) {
            return AbstractSQLPagingDialect.wrapCountSql(namedSql, selectIndex, orderByIndex, limitIndex);
        }
        int offsetIndex = sqlMetaData.getOffsetIndex();
        if (offsetIndex > 0) {
            return AbstractSQLPagingDialect.wrapCountSql(namedSql, selectIndex, orderByIndex, offsetIndex);
        }
        int fetchIndex = sqlMetaData.getFetchIndex();
        if (fetchIndex > 0) {
            return AbstractSQLPagingDialect.wrapCountSql(namedSql, selectIndex, orderByIndex, fetchIndex);
        }
        if (selectIndex > 0) {
            int fromIndex = sqlMetaData.getFromIndex();
            if (fromIndex > selectIndex) {
                int columnsBegin = selectIndex + SELECT_LEN;
                String columns = namedSql.substring(columnsBegin, fromIndex);
                String select = namedSql.substring(0, columnsBegin);
                if (columns.matches(COUNT_REGEX)) {
                    return namedSql;
                }
                int groupByIndex = sqlMetaData.getGroupByIndex();
                if (groupByIndex > fromIndex) {
                    if (orderByIndex > fromIndex) {
                        return StringUtils.concat((String[])new String[]{select, COUNT, namedSql.substring(fromIndex, orderByIndex)});
                    }
                    return StringUtils.concat((String[])new String[]{select, COUNT, namedSql.substring(fromIndex)});
                }
                columns = COUNT;
                if (orderByIndex > 0) {
                    return StringUtils.concat((String[])new String[]{select, columns, namedSql.substring(fromIndex, orderByIndex)});
                }
                return StringUtils.concat((String[])new String[]{select, columns, namedSql.substring(fromIndex)});
            }
            return StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex), COUNT_END});
        }
        return StringUtils.concat((String[])new String[]{COUNT_START, namedSql, COUNT_END});
    }

    private static String wrapCountSql(String namedSql, int selectIndex, int orderByIndex, int firstStatementIndexAfterOrderby) {
        namedSql = selectIndex > 0 ? (orderByIndex > selectIndex ? (firstStatementIndexAfterOrderby > orderByIndex ? StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex, orderByIndex), namedSql.substring(firstStatementIndexAfterOrderby), COUNT_END}) : StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex), COUNT_END})) : StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex), COUNT_END})) : StringUtils.concat((String[])new String[]{COUNT_START, namedSql, COUNT_END});
        return namedSql;
    }

    static {
        SELECT_LEN = SELECT.length();
        config = new Properties();
        PropertiesLoaderUtils.loadIgnoreException((Properties)config, (String)"sql-paging.properties");
        COUNT = StringUtils.concat((String[])new String[]{" COUNT(", config.getProperty("count.expression", "*"), ") "});
        COUNT_START = StringUtils.concat((String[])new String[]{SELECT, COUNT, "FROM ("});
    }
}

