/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.dialect.AbstractSQLPagingDialect;
import cn.tenmg.sql.paging.utils.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

public class OraclePagingDialect
extends AbstractSQLPagingDialect {
    private static final String PAGE_WRAP_START = "SELECT %s FROM (SELECT ROWNUM RN__, SQL_PAGING.* FROM (";
    private static final String PAGE_WRAP_END = ") SQL_PAGING WHERE ROWNUM <= %d) WHERE RN__ > %d";
    private static final String SUBQUERY_START = "SELECT * FROM (";
    private static final String SUBQUERY_END = ") SQL_PAGING";
    private static final String NEW_PAGE_WRAP_END = " OFFSET %d ROW FETCH NEXT %d ROW ONLY";
    private static final OraclePagingDialect INSTANCE = new OraclePagingDialect();

    public static OraclePagingDialect getInstance() {
        return INSTANCE;
    }

    protected OraclePagingDialect() {
    }

    @Override
    public String pageSql(Connection con, String namedSql, Map<String, ?> params, SQLMetaData sqlMetaData, int pageSize, long currentPage) throws SQLException {
        int selectIndex = sqlMetaData.getSelectIndex();
        if (con.getMetaData().getDatabaseMajorVersion() >= 12) {
            if (selectIndex >= 0) {
                if (sqlMetaData.getOffsetIndex() > 0 || sqlMetaData.getFetchIndex() > 0) {
                    return StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), SUBQUERY_START, namedSql.substring(selectIndex), SUBQUERY_END, OraclePagingDialect.newPageEnd(pageSize, currentPage)});
                }
                return namedSql.concat(OraclePagingDialect.newPageEnd(pageSize, currentPage));
            }
            return StringUtils.concat((String[])new String[]{SUBQUERY_START, namedSql, SUBQUERY_END, OraclePagingDialect.newPageEnd(pageSize, currentPage)});
        }
        String pageStart = OraclePagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData));
        if (selectIndex >= 0) {
            return StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), pageStart, namedSql.substring(selectIndex), OraclePagingDialect.pageEnd(pageSize, currentPage)});
        }
        return StringUtils.concat((String[])new String[]{pageStart, namedSql, OraclePagingDialect.pageEnd(pageSize, currentPage)});
    }

    private static String pageStart(String[] columnLabels) {
        return String.format(PAGE_WRAP_START, String.join((CharSequence)", ", columnLabels));
    }

    private static String pageEnd(int pageSize, long currentPage) {
        return String.format(PAGE_WRAP_END, currentPage * (long)pageSize, (currentPage - 1L) * (long)pageSize);
    }

    private static String newPageEnd(int pageSize, long currentPage) {
        return String.format(NEW_PAGE_WRAP_END, (currentPage - 1L) * (long)pageSize, pageSize);
    }
}

