/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sql.paging.dialect;

import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.sql.paging.SQLMetaData;
import cn.tenmg.sql.paging.dialect.AbstractSQLPagingDialect;
import cn.tenmg.sql.paging.utils.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

public class SQLServerPagingDialect
extends AbstractSQLPagingDialect {
    private static final String CONST_RN = "1 RN__,";
    private static final String PAGE_WRAP_START = "SELECT %s FROM (";
    private static final String SUBQUERY_START = "SELECT 1 RN__,SQL_PAGING.* FROM (";
    private static final String SUBQUERY_END = ") SQL_PAGING";
    private static final String ORDER_BY = "ORDER BY RN__";
    private static final String PAGE_WRAP_END = " OFFSET %d ROW FETCH NEXT %d ROW ONLY";
    private static final SQLServerPagingDialect INSTANCE = new SQLServerPagingDialect();

    public static SQLServerPagingDialect getInstance() {
        return INSTANCE;
    }

    protected SQLServerPagingDialect() {
    }

    @Override
    public String countSql(String namedSql, SQLMetaData sqlMetaData) {
        boolean isUnion = sqlMetaData.isUnion();
        int selectIndex = sqlMetaData.getSelectIndex();
        int orderByIndex = sqlMetaData.getOrderByIndex();
        int offsetIndex = sqlMetaData.getOffsetIndex();
        if (selectIndex >= 0) {
            if (offsetIndex > selectIndex) {
                return SQLServerPagingDialect.wrapLimitedSqlToCountSql(namedSql, selectIndex, orderByIndex, offsetIndex, isUnion);
            }
            int fetchIndex = sqlMetaData.getFetchIndex();
            if (offsetIndex > selectIndex) {
                return SQLServerPagingDialect.wrapLimitedSqlToCountSql(namedSql, selectIndex, orderByIndex, fetchIndex, isUnion);
            }
            return SQLServerPagingDialect.wrapUnLimitedSqlToCountSql(namedSql, selectIndex, sqlMetaData.getFromIndex(), sqlMetaData.getGroupByIndex(), orderByIndex, isUnion);
        }
        return StringUtils.concat((String[])new String[]{COUNT_START, namedSql, SUBQUERY_END});
    }

    @Override
    public String pageSql(Connection con, String namedSql, Map<String, ?> params, SQLMetaData sqlMetaData, int pageSize, long currentPage) throws SQLException {
        int selectIndex = sqlMetaData.getSelectIndex();
        String pageEnd = SQLServerPagingDialect.pageEnd(pageSize, currentPage);
        if (selectIndex >= 0) {
            int offsetIndex = sqlMetaData.getOffsetIndex();
            if (offsetIndex > selectIndex) {
                return SQLServerPagingDialect.wrapLimitedSqlToPageSql(namedSql, SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), pageEnd, selectIndex, sqlMetaData.getOrderByIndex(), offsetIndex, sqlMetaData.isUnion());
            }
            int fetchIndex = sqlMetaData.getFetchIndex();
            if (fetchIndex > selectIndex) {
                return SQLServerPagingDialect.wrapLimitedSqlToPageSql(namedSql, SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), pageEnd, selectIndex, sqlMetaData.getOrderByIndex(), fetchIndex, sqlMetaData.isUnion());
            }
            int orderByIndex = sqlMetaData.getOrderByIndex();
            if (orderByIndex > 0) {
                return namedSql.concat(pageEnd);
            }
            int selectEndIndex = selectIndex + SELECT_LEN;
            return StringUtils.concat((Object[])new Object[]{namedSql.substring(0, selectIndex), SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), namedSql.substring(selectIndex, selectEndIndex), Character.valueOf(' '), CONST_RN, SQLServerPagingDialect.insertConstantColumnAfterSelect(namedSql.substring(selectEndIndex)), Character.valueOf(' '), ORDER_BY, pageEnd, SUBQUERY_END});
        }
        return StringUtils.concat((Object[])new Object[]{SQLServerPagingDialect.pageStart(SQLUtils.getColumnLabels(con, namedSql, params, sqlMetaData)), SUBQUERY_START, namedSql, SUBQUERY_END, Character.valueOf(' '), ORDER_BY, pageEnd, SUBQUERY_END});
    }

    private static String wrapLimitedSqlToCountSql(String namedSql, int selectIndex, int orderByIndex, int firstStatementIndexAfterOrderby, boolean isUnion) {
        if (orderByIndex > selectIndex) {
            namedSql = StringUtils.concat((String[])new String[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex), SUBQUERY_END});
        } else {
            int selectEndIndex = selectIndex + SELECT_LEN;
            namedSql = isUnion ? StringUtils.concat((Object[])new Object[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex, selectEndIndex), Character.valueOf(' '), CONST_RN, SQLServerPagingDialect.insertConstantColumnAfterSelect(namedSql.substring(selectEndIndex, firstStatementIndexAfterOrderby)), ORDER_BY, Character.valueOf(' '), namedSql.substring(firstStatementIndexAfterOrderby), SUBQUERY_END}) : StringUtils.concat((Object[])new Object[]{namedSql.substring(0, selectIndex), COUNT_START, namedSql.substring(selectIndex, selectEndIndex), Character.valueOf(' '), CONST_RN, namedSql.substring(selectEndIndex, firstStatementIndexAfterOrderby), ORDER_BY, Character.valueOf(' '), namedSql.substring(firstStatementIndexAfterOrderby), SUBQUERY_END});
        }
        return namedSql;
    }

    private static StringBuilder insertConstantColumnAfterSelect(String sql) {
        int backslashes = 0;
        int deep = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        StringBuilder sqlBuilder = new StringBuilder();
        StringBuilder wordBuilder = new StringBuilder();
        int len = sql.length();
        for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (DSLUtils.isStringEnd((char)a, (char)b, (char)c, (int)backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
            } else if (c == '\'') {
                isString = true;
            } else if (c == '(') {
                ++deep;
                wordBuilder.setLength(0);
            } else if (c == ')') {
                --deep;
                wordBuilder.setLength(0);
            } else if (c <= ' ') {
                if (deep == 0 && "SELECT".equalsIgnoreCase(wordBuilder.toString())) {
                    sqlBuilder.append(' ').append(CONST_RN);
                }
                wordBuilder.setLength(0);
            } else {
                wordBuilder.append(c);
            }
            sqlBuilder.append(c);
            a = b;
            b = c;
        }
        return sqlBuilder;
    }

    private static String wrapLimitedSqlToPageSql(String namedSql, String pageStart, String pageEnd, int selectIndex, int orderByIndex, int firstStatementIndexAfterOrderby, boolean isUnion) {
        if (orderByIndex > selectIndex) {
            return StringUtils.concat((Object[])new Object[]{namedSql.substring(0, selectIndex), pageStart, SUBQUERY_START, namedSql.substring(selectIndex), SUBQUERY_END, Character.valueOf(' '), ORDER_BY, pageEnd, SUBQUERY_END});
        }
        int selectEndIndex = selectIndex + SELECT_LEN;
        namedSql = isUnion ? StringUtils.concat((Object[])new Object[]{namedSql.substring(0, selectIndex), pageStart, namedSql.substring(selectIndex, selectEndIndex), Character.valueOf(' '), CONST_RN, SQLServerPagingDialect.insertConstantColumnAfterSelect(namedSql.substring(selectEndIndex, firstStatementIndexAfterOrderby)), ORDER_BY, " ", namedSql.substring(firstStatementIndexAfterOrderby), SUBQUERY_END, Character.valueOf(' '), ORDER_BY, pageEnd}) : StringUtils.concat((Object[])new Object[]{namedSql.substring(0, selectIndex), pageStart, namedSql.substring(selectIndex, selectEndIndex), Character.valueOf(' '), CONST_RN, namedSql.substring(selectEndIndex, firstStatementIndexAfterOrderby), ORDER_BY, " ", namedSql.substring(firstStatementIndexAfterOrderby), SUBQUERY_END, Character.valueOf(' '), ORDER_BY, pageEnd});
        return namedSql;
    }

    private static String pageStart(String[] columnLabels) {
        return String.format(PAGE_WRAP_START, String.join((CharSequence)", ", columnLabels));
    }

    private static String pageEnd(int pageSize, long currentPage) {
        return String.format(PAGE_WRAP_END, (currentPage - 1L) * (long)pageSize, pageSize);
    }
}

