/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.executer;

import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.SqlExecuter;
import cn.tenmg.sqltool.sql.utils.FieldUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;

public class GetSqlExecuter<T>
implements SqlExecuter<T> {
    private static final long serialVersionUID = 5489699234751455394L;
    protected Class<T> type;

    public GetSqlExecuter() {
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public GetSqlExecuter(Class<T> type) {
        this.type = type;
    }

    @Override
    public ResultSet execute(PreparedStatement ps) throws SQLException {
        return ps.executeQuery();
    }

    @Override
    public T execute(PreparedStatement ps, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Object row = null;
        if (String.class.isAssignableFrom(this.type) || Number.class.isAssignableFrom(this.type) || Date.class.isAssignableFrom(this.type) || BigDecimal.class.isAssignableFrom(this.type)) {
            if (rs.next()) {
                row = rs.getObject(1);
            }
        } else {
            HashMap<String, Integer> feildNames = new HashMap<String, Integer>();
            for (int i = 1; i <= columnCount; ++i) {
                String feildName = StringUtils.toCamelCase(rsmd.getColumnLabel(i), "_", false);
                feildNames.put(feildName, i);
            }
            HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
            Class<T> current = this.type;
            while (!Object.class.equals(current)) {
                FieldUtils.parseFields(feildNames, fieldMap, current.getDeclaredFields());
                current = current.getSuperclass();
            }
            if (rs.next()) {
                try {
                    row = this.type.newInstance();
                    for (int i = 1; i <= columnCount; ++i) {
                        Field field = (Field)fieldMap.get(i);
                        if (field == null) continue;
                        field.set(row, rs.getObject(i));
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new DataAccessException(e);
                }
            }
        }
        return (T)row;
    }
}

