/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.utils.CollectionUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Could not close JDBC Connection", (Throwable)ex);
                }
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                if (log.isErrorEnabled()) {
                    log.error("Unexpected exception on closing JDBC Connection", ex);
                }
                ex.printStackTrace();
            }
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Could not close JDBC Statement", (Throwable)ex);
                }
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                if (log.isErrorEnabled()) {
                    log.error("Unexpected exception on closing JDBC Statement", ex);
                }
                ex.printStackTrace();
            }
        }
    }

    public static void close(ResultSet resultSet) {
        block5: {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Could not close JDBC ResultSet", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error("Unexpected exception on closing JDBC ResultSet", ex);
                }
            }
        }
    }

    public static <T> List<Object> getParams(T obj, List<Field> fields) {
        ArrayList<Object> params = new ArrayList<Object>();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            try {
                params.add(fields.get(i).get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
        return params;
    }

    public static void setParams(PreparedStatement ps, List<Object> params) throws SQLException {
        if (!CollectionUtils.isEmpty(params)) {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params.get(i));
            }
        }
    }
}

