/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool;

import cn.tenmg.sqltool.SqltoolFactory;
import cn.tenmg.sqltool.Transaction;
import cn.tenmg.sqltool.dsql.Sql;
import cn.tenmg.sqltool.dsql.utils.DsqlUtils;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.SQLException;
import cn.tenmg.sqltool.exception.TransactionException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.JdbcSql;
import cn.tenmg.sqltool.sql.MergeSql;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SqlExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteSqlExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSqlExecuter;
import cn.tenmg.sqltool.sql.executer.GetSqlExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSqlExecuter;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SqltoolContext
implements Serializable {
    private static final long serialVersionUID = -840162594918947327L;
    private static final Logger log = Logger.getLogger(SqltoolContext.class);
    private SqltoolFactory sqltoolFactory;
    private boolean showSql = true;
    private int defaultBatchSize = 500;
    private static ThreadLocal<Connection> currentConnection = new ThreadLocal();

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public SqltoolContext() {
    }

    public SqltoolContext(SqltoolFactory sqltoolFactory) {
        this.sqltoolFactory = sqltoolFactory;
    }

    public SqltoolContext(SqltoolFactory sqltoolFactory, boolean showSql) {
        this.sqltoolFactory = sqltoolFactory;
        this.showSql = showSql;
    }

    public SqltoolContext(SqltoolFactory sqltoolFactory, boolean showSql, int defaultBatchSize) {
        this.sqltoolFactory = sqltoolFactory;
        this.showSql = showSql;
        this.defaultBatchSize = defaultBatchSize;
    }

    public <T extends Serializable> int insert(Map<String, String> options, T obj) {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
        return this.execute(options, dml.getSql(), params, ExecuteUpdateSqlExecuter.getInstance());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> int insert(Map<String, String> options, List<T> rows) {
        int n;
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            n = JdbcUtils.insert(con, this.showSql, rows);
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                    throw new SQLException(e);
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalConfigException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.close(con);
                throw throwable;
            }
        }
        JdbcUtils.close(con);
        return n;
    }

    public <T extends Serializable> void insertBatch(Map<String, String> options, List<T> rows) {
        this.insertBatch(options, rows, this.defaultBatchSize);
    }

    public <T extends Serializable> void insertBatch(Map<String, String> options, List<T> rows, int batchSize) {
        if (!CollectionUtils.isEmpty(rows)) {
            DML dml = InsertDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
            this.executeBatch(options, dml.getSql(), rows, dml.getFields(), batchSize);
        }
    }

    public <T extends Serializable> int save(Map<String, String> options, T obj) {
        JdbcSql jdbcSql = SQLDialectUtils.getSQLDialect(options).save(obj);
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance());
    }

    public <T extends Serializable> int save(Map<String, String> options, T obj, String ... hardFields) {
        JdbcSql jdbcSql = SQLDialectUtils.getSQLDialect(options).save(obj, hardFields);
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance());
    }

    public <T extends Serializable> int save(Map<String, String> options, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return SqltoolContext.save(options, this.showSql, rows, SQLDialectUtils.getSQLDialect(options).save(((Serializable)rows.get(0)).getClass()));
    }

    public <T extends Serializable> int save(Map<String, String> options, List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return SqltoolContext.save(options, this.showSql, rows, SQLDialectUtils.getSQLDialect(options).save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows) {
        this.saveBatch(options, rows, this.defaultBatchSize);
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows, String ... hardFields) {
        this.saveBatch(options, rows, this.defaultBatchSize, hardFields);
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.saveBatch(options, rows, batchSize, SQLDialectUtils.getSQLDialect(options).save(((Serializable)rows.get(0)).getClass()));
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows, int batchSize, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.saveBatch(options, rows, batchSize, SQLDialectUtils.getSQLDialect(options).save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    public <T extends Serializable> int hardSave(Map<String, String> options, T obj) {
        JdbcSql jdbcSql = SQLDialectUtils.getSQLDialect(options).hardSave(obj);
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> int hardSave(Map<String, String> options, List<T> rows) {
        int n;
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        SQLDialect dialect = SQLDialectUtils.getSQLDialect(options);
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            n = JdbcUtils.hardSave(con, dialect, this.showSql, rows);
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                    throw new SQLException(e);
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalConfigException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.close(con);
                throw throwable;
            }
        }
        JdbcUtils.close(con);
        return n;
    }

    public <T extends Serializable> void hardSaveBatch(Map<String, String> options, List<T> rows) {
        this.hardSaveBatch(options, rows, this.defaultBatchSize);
    }

    public <T extends Serializable> void hardSaveBatch(Map<String, String> options, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = SQLDialectUtils.getSQLDialect(options);
        Connection con = null;
        Statement ps = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            MergeSql mergeSql = dialect.hardSave(((Serializable)rows.get(0)).getClass());
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (this.showSql) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (java.sql.SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
            JdbcUtils.close(con);
        }
    }

    public <T extends Serializable> T get(Map<String, String> options, T obj) {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)this.execute(options, dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSqlExecuter(type)));
    }

    public <T extends Serializable> T get(Map<String, String> options, Class<T> type, String dsql, Object ... params) {
        return this.get(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Map<String, String> options, Class<T> type, String dsql, Map<String, ?> params) {
        return this.get(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Map<String, String> options, T obj) {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (List)this.execute(options, dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new SelectSqlExecuter(type));
    }

    public <T extends Serializable> List<T> select(Map<String, String> options, Class<T> type, String dsql, Object ... params) {
        return this.select(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Map<String, String> options, Class<T> type, String dsql, Map<String, ?> params) {
        return this.select(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public boolean execute(Map<String, String> options, String dsql, Object ... params) {
        return this.execute(options, this.sqltoolFactory.parse(dsql, params));
    }

    public boolean execute(Map<String, String> options, String dsql, Map<String, ?> params) {
        return this.execute(options, this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(Map<String, String> options, String dsql, Object ... params) {
        return this.executeUpdate(options, this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(Map<String, String> options, String dsql, Map<String, ?> params) {
        return this.executeUpdate(options, this.sqltoolFactory.parse(dsql, params));
    }

    public void execute(Map<String, String> options, Transaction transaction) {
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            currentConnection.set(con);
            transaction.execute(new SqltoolExecutor(this.showSql, this.sqltoolFactory, SQLDialectUtils.getSQLDialect(options)));
            con.commit();
        }
        catch (Exception e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                if (e instanceof ClassNotFoundException) {
                    throw new IllegalConfigException(e);
                }
                if (e instanceof java.sql.SQLException) {
                    throw new SQLException(e);
                }
                throw new TransactionException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(con);
                throw throwable;
            }
        }
        JdbcUtils.close(con);
    }

    private <T extends Serializable> T get(Map<String, String> options, Sql sql, Class<T> type) {
        return (T)((Serializable)this.execute(options, sql, new GetSqlExecuter<T>(type)));
    }

    private <T extends Serializable> List<T> select(Map<String, String> options, Sql sql, Class<T> type) {
        return (List)this.execute(options, sql, new SelectSqlExecuter<T>(type));
    }

    private boolean execute(Map<String, String> options, Sql sql) {
        return this.execute(options, sql, ExecuteSqlExecuter.getInstance());
    }

    private int executeUpdate(Map<String, String> options, Sql sql) {
        return this.execute(options, sql, ExecuteUpdateSqlExecuter.getInstance());
    }

    private <T> T execute(Map<String, String> options, Sql sql, SqlExecuter<T> sqlExecuter) {
        JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), sqlExecuter);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Map<String, String> options, String sql, List<Object> params, SqlExecuter<T> sqlExecuter) {
        Connection con = null;
        T result = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            result = JdbcUtils.execute(con, sql, params, sqlExecuter, this.showSql);
        }
        catch (java.sql.SQLException e) {
            try {
                throw new SQLException(e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalConfigException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.close(con);
                throw throwable;
            }
        }
        JdbcUtils.close(con);
        return result;
    }

    private <T extends Serializable> void executeBatch(Map<String, String> options, String sql, List<T> rows, List<Field> fields, int batchSize) {
        Connection con = null;
        Statement ps = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            ps = con.prepareStatement(sql);
            if (this.showSql) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (java.sql.SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
            JdbcUtils.close(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> int save(Map<String, String> options, boolean showSql, List<T> rows, MergeSql mergeSql) {
        int n;
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            n = JdbcUtils.save(con, showSql, rows, mergeSql);
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                    throw new SQLException(e);
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalConfigException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.close(con);
                throw throwable;
            }
        }
        JdbcUtils.close(con);
        return n;
    }

    private <T> void saveBatch(Map<String, String> options, List<T> rows, int batchSize, MergeSql mergeSql) {
        Connection con = null;
        Statement ps = null;
        try {
            int size = rows.size();
            int current = 0;
            int times = (int)Math.ceil((double)size / (double)batchSize);
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (this.showSql) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(mergeSql.getScript());
            while (current < times) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
                ++current;
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (java.sql.SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
            JdbcUtils.close(con);
        }
    }

    public static class SqltoolExecutor
    implements Serializable {
        private static final long serialVersionUID = -185528394193239604L;
        private boolean showSql = true;
        private SqltoolFactory sqltoolFactory;
        private SQLDialect dialect;

        public SqltoolExecutor(boolean showSql, SqltoolFactory sqltoolFactory, SQLDialect dialect) {
            this.showSql = showSql;
            this.sqltoolFactory = sqltoolFactory;
            this.dialect = dialect;
        }

        public int insert(Object obj) {
            DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
            String sql = dml.getSql();
            List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(sql).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            try {
                return JdbcUtils.execute((Connection)currentConnection.get(), sql, params, ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int insert(List<T> rows) {
            if (CollectionUtils.isEmpty(rows)) {
                return 0;
            }
            DML dml = InsertDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
            String sql = dml.getSql();
            if (this.showSql) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            try {
                return JdbcUtils.insert((Connection)currentConnection.get(), this.showSql, rows);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int save(T obj) {
            JdbcSql jdbcSql = this.dialect.save(obj);
            try {
                return JdbcUtils.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int save(T obj, String ... hardFields) {
            JdbcSql jdbcSql = this.dialect.save(obj, hardFields);
            try {
                return JdbcUtils.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int save(List<T> rows) {
            if (CollectionUtils.isEmpty(rows)) {
                return 0;
            }
            try {
                return JdbcUtils.save((Connection)currentConnection.get(), this.showSql, rows, this.dialect.save(((Serializable)rows.get(0)).getClass()));
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int save(List<T> rows, String ... hardFields) {
            if (CollectionUtils.isEmpty(rows)) {
                return 0;
            }
            try {
                return JdbcUtils.save((Connection)currentConnection.get(), this.showSql, rows, this.dialect.save(((Serializable)rows.get(0)).getClass(), hardFields));
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int hardSave(T obj) {
            JdbcSql jdbcSql = this.dialect.hardSave(obj);
            try {
                return JdbcUtils.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int hardSave(List<T> rows) {
            if (CollectionUtils.isEmpty(rows)) {
                return 0;
            }
            try {
                return JdbcUtils.hardSave((Connection)currentConnection.get(), this.dialect, this.showSql, rows);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> T get(T obj) {
            Class<?> type = obj.getClass();
            DML dml = GetDMLParser.getInstance().parse(type);
            try {
                return (T)((Serializable)JdbcUtils.execute((Connection)currentConnection.get(), dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSqlExecuter(type), this.showSql));
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> T get(Map<String, String> options, Class<T> type, String dsql, Object ... params) {
            return this.get(this.sqltoolFactory.parse(dsql, params), type);
        }

        public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) {
            return this.get(this.sqltoolFactory.parse(dsql, params), type);
        }

        public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) {
            return this.select(this.sqltoolFactory.parse(dsql, params), type);
        }

        public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) {
            return this.select(this.sqltoolFactory.parse(dsql, params), type);
        }

        public boolean execute(String dsql, Object ... params) {
            return this.execute(this.sqltoolFactory.parse(dsql, params));
        }

        public boolean execute(String dsql, Map<String, ?> params) {
            return this.execute(this.sqltoolFactory.parse(dsql, params));
        }

        public int executeUpdate(String dsql, Object ... params) {
            return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
        }

        public int executeUpdate(String dsql, Map<String, ?> params) {
            return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
        }

        private boolean execute(Sql sql) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            PreparedStatement ps = null;
            boolean rs = false;
            Connection con = (Connection)currentConnection.get();
            try {
                ps = con.prepareStatement(jdbcSql.getScript());
                JdbcUtils.setParams(ps, jdbcSql.getParams());
                rs = ps.execute();
            }
            catch (java.sql.SQLException e) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (java.sql.SQLException ex) {
                        ex.printStackTrace();
                    }
                    throw new SQLException(e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            JdbcUtils.close(ps);
            return rs;
        }

        private int executeUpdate(Sql sql) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            PreparedStatement ps = null;
            int count = 0;
            Connection con = (Connection)currentConnection.get();
            try {
                String script = jdbcSql.getScript();
                List<Object> params = jdbcSql.getParams();
                ps = con.prepareStatement(script);
                JdbcUtils.setParams(ps, params);
                if (this.showSql) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Execute SQL: ").append(script).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                    log.info((Object)sb.toString());
                }
                count = ps.executeUpdate();
            }
            catch (java.sql.SQLException e) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (java.sql.SQLException ex) {
                        ex.printStackTrace();
                    }
                    throw new SQLException(e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            JdbcUtils.close(ps);
            return count;
        }

        private <T extends Serializable> T get(Sql sql, Class<T> type) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            try {
                return (T)((Serializable)JdbcUtils.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), new GetSqlExecuter<T>(type), this.showSql));
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        private <T extends Serializable> List<T> select(Sql sql, Class<T> type) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            try {
                return (List)JdbcUtils.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), new SelectSqlExecuter<T>(type), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }
    }
}

