/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.spark;

import cn.tenmg.sqltool.SqltoolFactory;
import cn.tenmg.sqltool.dsql.Sql;
import cn.tenmg.sqltool.sql.engine.SparkSQLSqlEngine;
import cn.tenmg.sqltool.utils.SqlEngineUtils;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class SparkDataLoader
implements Serializable {
    private static final long serialVersionUID = -3061843065600681110L;
    private SqltoolFactory sqltoolFactory;

    public SparkDataLoader(SqltoolFactory sqltoolFactory) {
        this.sqltoolFactory = sqltoolFactory;
    }

    public Dataset<Row> load(SparkSession sparkSession, Map<String, String> options, String dsql, Object ... params) {
        return this.load(sparkSession, options, this.sqltoolFactory.parse(dsql, params));
    }

    public Dataset<Row> load(SparkSession sparkSession, Map<String, String> options, String dsql, Map<String, Object> params) {
        return this.load(sparkSession, options, this.sqltoolFactory.parse(dsql, params));
    }

    public Dataset<Row> sql(SparkSession sparkSession, String dsql, Object ... params) {
        return this.sql(sparkSession, this.sqltoolFactory.parse(dsql, params));
    }

    public Dataset<Row> sql(SparkSession sparkSession, String dsql, Map<String, Object> params) {
        return this.sql(sparkSession, this.sqltoolFactory.parse(dsql, params));
    }

    private Dataset<Row> load(SparkSession sparkSession, Map<String, String> options, Sql sql) {
        return sparkSession.sqlContext().read().options(options).option("query", SqlEngineUtils.getSqlEngine(options.get("url")).parse(sql)).format("jdbc").load();
    }

    private Dataset<Row> sql(SparkSession sparkSession, Sql sql) {
        return sparkSession.sqlContext().sql(SparkSQLSqlEngine.getInstance().parse(sql));
    }
}

