/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.ColumnNotFoundException;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.JdbcSql;
import cn.tenmg.sqltool.sql.MergeSql;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.PlaceHolderUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSQLDialect
implements SQLDialect {
    private static final long serialVersionUID = -5454570237300496297L;
    protected static final String TABLE_NAME = "tableName";
    protected static final String COLUMNS = "columns";
    protected static final String VALUES = "values";
    protected static final String SETS = "sets";
    protected static final String LEFT_COLUMN_NAME = "columnName";
    protected static final String RIGHT_COLUMN_NAME = "columnName";

    abstract List<String> getExtSQLTemplateParamNames();

    abstract String getSaveSQLTemplate();

    abstract String getInsertIfNotExistsSQLTemplate();

    abstract List<String> getNeedsCommaParamNames();

    abstract void handleColumn(String var1, Map<String, StringBuilder> var2);

    abstract void handleIdColumn(String var1, Map<String, StringBuilder> var2, boolean var3);

    abstract String getSetTemplate();

    abstract String getSetIfNotNullTemplate();

    protected static EntityMeta getCachedEntityMeta(Class<?> type) {
        return (EntityMeta)EntityMetaCacheHolder.CACHE.get(type);
    }

    protected static synchronized void cacheEntityMeta(Class<?> type, EntityMeta entityMeta) {
        EntityMetaCacheHolder.CACHE.put(type, entityMeta);
    }

    @Override
    public <T> MergeSql save(Class<T> type) {
        EntityMeta entityMeta = AbstractSQLDialect.getCachedEntityMeta(type);
        boolean flag = false;
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                flag = this.parse(type, templateParams, fieldMetas);
                entityMeta.setFieldMetas(fieldMetas);
                AbstractSQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                StringBuilder sets = templateParams.get(SETS);
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSetIfNotNull(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (flag) {
            return this.mergeSql(entityMeta, templateParams);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    @Override
    public <T> MergeSql save(Class<T> type, String ... hardFields) {
        HashSet<String> hardFieldSet = new HashSet<String>();
        for (int i = 0; i < hardFields.length; ++i) {
            hardFieldSet.add(hardFields[i]);
        }
        boolean flag = false;
        EntityMeta entityMeta = AbstractSQLDialect.getCachedEntityMeta(type);
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                flag = this.parse(type, templateParams, fieldMetas, hardFieldSet);
                entityMeta.setFieldMetas(fieldMetas);
                AbstractSQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                StringBuilder sets = templateParams.get(SETS);
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    if (hardFieldSet.contains(field.getName())) {
                        this.appendSet(sets, columnName);
                        continue;
                    }
                    this.appendSetIfNotNull(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (flag) {
            return this.mergeSql(entityMeta, templateParams);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    @Override
    public <T> MergeSql hardSave(Class<T> type) {
        EntityMeta entityMeta = AbstractSQLDialect.getCachedEntityMeta(type);
        boolean columnNotFound = false;
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnNotFound = this.hardParse(type, templateParams, fieldMetas);
                entityMeta.setFieldMetas(fieldMetas);
                AbstractSQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                StringBuilder sets = templateParams.get(SETS);
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    if (columnNotFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnNotFound = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnNotFound) {
            return this.mergeSql(entityMeta, templateParams);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    @Override
    public <T> JdbcSql save(T obj) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = AbstractSQLDialect.getCachedEntityMeta(type);
        boolean flag = false;
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                flag = this.parse(obj, templateParams, params, fieldMetas);
                entityMeta.setFieldMetas(fieldMetas);
                AbstractSQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                StringBuilder sets = templateParams.get(SETS);
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Object param = fieldMeta.getField().get(obj);
                    if (param == null) continue;
                    params.add(param);
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (flag) {
            return this.jdbcSql(entityMeta.getTableName(), templateParams, params);
        }
        throw new ColumnNotFoundException(String.format("Not null column not found in class %s, please use @Column to config fields and make sure at lease one of them is not null", type.getName()));
    }

    @Override
    public <T> JdbcSql save(T obj, String ... hardFields) {
        HashSet<String> hardFieldSet = new HashSet<String>();
        for (int i = 0; i < hardFields.length; ++i) {
            hardFieldSet.add(hardFields[i]);
        }
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = AbstractSQLDialect.getCachedEntityMeta(type);
        boolean flag = false;
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                flag = this.parse(obj, templateParams, params, fieldMetas, hardFieldSet);
                entityMeta.setFieldMetas(fieldMetas);
                AbstractSQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                StringBuilder sets = templateParams.get(SETS);
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    Object param = field.get(obj);
                    if (param == null && !hardFieldSet.contains(field.getName())) continue;
                    params.add(param);
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (flag) {
            return this.jdbcSql(entityMeta.getTableName(), templateParams, params);
        }
        throw new ColumnNotFoundException(String.format("Not null or hard save column not found in class %s, please use @Column to config fields and make sure at lease one of them is not null or hard save", type.getName()));
    }

    @Override
    public <T> JdbcSql hardSave(T obj) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = AbstractSQLDialect.getCachedEntityMeta(type);
        boolean columnNotFound = false;
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnNotFound = this.hardParse(obj, templateParams, params, fieldMetas);
                entityMeta.setFieldMetas(fieldMetas);
                AbstractSQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                StringBuilder sets = templateParams.get(SETS);
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    params.add(field.get(obj));
                    if (columnNotFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnNotFound = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnNotFound) {
            return this.jdbcSql(entityMeta.getTableName(), templateParams, params);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    private <T> boolean parse(Class<T> type, Map<String, StringBuilder> templateParams, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<T> current = type;
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumn(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSetIfNotNull(sets, columnName);
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumn(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean parse(Class<T> type, Map<String, StringBuilder> templateParams, List<FieldMeta> fieldMetas, Set<String> hardFieldSet) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<T> current = type;
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumn(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    sets = templateParams.get(SETS);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    if (hardFieldSet.contains(field.getName())) {
                        this.appendSet(sets, columnName);
                    } else {
                        this.appendSetIfNotNull(sets, columnName);
                    }
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumn(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean hardParse(Class<T> type, Map<String, StringBuilder> templateParams, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<T> current = type;
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumn(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumn(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean parse(T obj, Map<String, StringBuilder> templateParams, List<Object> params, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                Object param = field.get(obj);
                if (param != null) {
                    params.add(param);
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                        if (setsFlag) {
                            sets.append(", ");
                        } else {
                            setsFlag = true;
                        }
                        this.appendSet(sets, columnName);
                    } else {
                        fieldMeta.setId(true);
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                    }
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean parse(T obj, Map<String, StringBuilder> templateParams, List<Object> params, List<FieldMeta> fieldMetas, Set<String> hardFieldSet) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                Object param = field.get(obj);
                if (param != null || hardFieldSet.contains(field.getName())) {
                    params.add(param);
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumn(columnName, templateParams);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                        if (setsFlag) {
                            sets.append(", ");
                        } else {
                            setsFlag = true;
                        }
                        this.appendSet(sets, columnName);
                    } else {
                        fieldMeta.setId(true);
                        this.handleIdColumn(columnName, templateParams, setsFlag);
                    }
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean hardParse(T obj, Map<String, StringBuilder> templateParams, List<Object> params, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                params.add(field.get(obj));
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumn(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumn(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private Map<String, StringBuilder> getSQLTemplateParams() {
        HashMap<String, StringBuilder> params = new HashMap<String, StringBuilder>();
        params.put(COLUMNS, new StringBuilder());
        params.put(VALUES, new StringBuilder());
        params.put(SETS, new StringBuilder());
        List<String> paramNames = this.getExtSQLTemplateParamNames();
        if (paramNames != null) {
            int size = paramNames.size();
            for (int i = 0; i < size; ++i) {
                params.put(paramNames.get(i), new StringBuilder());
            }
        }
        return params;
    }

    private void appendSet(StringBuilder sets, String columnName) {
        sets.append(PlaceHolderUtils.replace(this.getSetTemplate(), "columnName", columnName));
    }

    private void appendSetIfNotNull(StringBuilder sets, String columnName) {
        sets.append(PlaceHolderUtils.replace(this.getSetIfNotNullTemplate(), "columnName", columnName));
    }

    private static final void appendComma(Map<String, StringBuilder> params, List<String> paramNames) {
        int size = paramNames.size();
        for (int i = 0; i < size; ++i) {
            params.get(paramNames.get(i)).append(", ");
        }
    }

    private MergeSql mergeSql(EntityMeta entityMeta, Map<String, StringBuilder> templateParams) {
        templateParams.put(TABLE_NAME, new StringBuilder(entityMeta.getTableName()));
        if (templateParams.get(SETS).length() > 0) {
            return new MergeSql(PlaceHolderUtils.replace(this.getSaveSQLTemplate(), templateParams), entityMeta.getFieldMetas());
        }
        return new MergeSql(PlaceHolderUtils.replace(this.getInsertIfNotExistsSQLTemplate(), templateParams), entityMeta.getFieldMetas());
    }

    private JdbcSql jdbcSql(String tableName, Map<String, StringBuilder> templateParams, List<Object> params) {
        templateParams.put(TABLE_NAME, new StringBuilder(tableName));
        if (templateParams.get(SETS).length() > 0) {
            return new JdbcSql(PlaceHolderUtils.replace(this.getSaveSQLTemplate(), templateParams), params);
        }
        return new JdbcSql(PlaceHolderUtils.replace(this.getInsertIfNotExistsSQLTemplate(), templateParams), params);
    }

    private static final class EntityMetaCacheHolder {
        private static volatile Map<Class<?>, EntityMeta> CACHE = new HashMap();

        private EntityMetaCacheHolder() {
        }
    }
}

