/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sqltool.sql.dialect.AbstractSQLDialect;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MySQLDialect
extends AbstractSQLDialect {
    private static final long serialVersionUID = 7189284927835898553L;
    private static final String INSERT_IF_NOT_EXISTS = "INSERT IGNORE INTO ${tableName} (${columns}) VALUES (${values})";
    private static final String SAVE = "INSERT INTO ${tableName} (${columns}) VALUES (${values}) ON DUPLICATE KEY UPDATE ${sets}";
    private static final List<String> NEEDS_COMMA_PARAM_NAMES = Arrays.asList("columns", "values");
    private static final String SET_TEMPLATE = "${columnName}=VALUES(${columnName})";
    private static final String SET_IF_NOT_NULL_TEMPLATE = "${columnName}=IFNULL(VALUES(${columnName}), ${columnName})";

    public static final MySQLDialect getInstance() {
        return InstanceHolder.INSTANCE;
    }

    protected static EntityMeta getCachedEntityMeta(Class<?> type) {
        return (EntityMeta)EntityMetaCacheHolder.CACHE.get(type);
    }

    protected static synchronized void cacheEntityMeta(Class<?> type, EntityMeta entityMeta) {
        EntityMetaCacheHolder.CACHE.put(type, entityMeta);
    }

    @Override
    List<String> getExtSQLTemplateParamNames() {
        return null;
    }

    @Override
    String getSaveSQLTemplate() {
        return SAVE;
    }

    @Override
    String getInsertIfNotExistsSQLTemplate() {
        return INSERT_IF_NOT_EXISTS;
    }

    @Override
    List<String> getNeedsCommaParamNames() {
        return NEEDS_COMMA_PARAM_NAMES;
    }

    @Override
    void handleColumn(String columnName, Map<String, StringBuilder> templateParams) {
        templateParams.get("columns").append(columnName);
        templateParams.get("values").append('?');
    }

    @Override
    void handleIdColumn(String columnName, Map<String, StringBuilder> templateParams, boolean notFirst) {
    }

    @Override
    String getSetTemplate() {
        return SET_TEMPLATE;
    }

    @Override
    String getSetIfNotNullTemplate() {
        return SET_IF_NOT_NULL_TEMPLATE;
    }

    private static final class EntityMetaCacheHolder {
        private static volatile Map<Class<?>, EntityMeta> CACHE = new HashMap();

        private EntityMetaCacheHolder() {
        }
    }

    private static class InstanceHolder {
        private static final MySQLDialect INSTANCE = new MySQLDialect();

        private InstanceHolder() {
        }
    }
}

