/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.engine;

import cn.tenmg.sqltool.sql.engine.AbstractSqlEngine;
import cn.tenmg.sqltool.utils.DateUtils;
import java.sql.Timestamp;
import java.util.Date;

public class OracleSqlEngine
extends AbstractSqlEngine {
    private static final long serialVersionUID = -6048522993125955852L;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    private static final String DATE_PATTERN = "YYYY-MM-DD HH24:MI:SS";
    private static final String TIMESTAMP_PATTERN = "YYYY-MM-DD HH24:MI:SS.FF6";

    public static final OracleSqlEngine getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    String parse(Date date) {
        if (date instanceof Timestamp) {
            return "TO_TIMESTAMP('".concat(DateUtils.format(date, TIMESTAMP_FORMAT)).concat("', '").concat(TIMESTAMP_PATTERN).concat("')");
        }
        return "TO_DATE('".concat(DateUtils.format(date, DATE_FORMAT)).concat("', '").concat(DATE_PATTERN).concat("')");
    }

    private static class InstanceHolder {
        private static final OracleSqlEngine INSTANCE = new OracleSqlEngine();

        private InstanceHolder() {
        }
    }
}

