/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.parser;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.PkNotFoundException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.parser.AbstractDMLParser;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class GetDMLParser
extends AbstractDMLParser {
    private static final long serialVersionUID = -5532695002201313950L;
    private static final String GET = "SELECT %s FROM %s WHERE %s";

    public static final GetDMLParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    protected <T> void parseDML(DML dml, Class<T> type, String tableName) {
        Class<T> current = type;
        boolean columnsFlag = false;
        boolean criteriaFlag = false;
        StringBuilder columns = new StringBuilder();
        StringBuilder criteria = new StringBuilder();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Field> idFields = new ArrayList<Field>();
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                fields.add(field);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                if (field.getAnnotation(Id.class) != null) {
                    idFields.add(field);
                    if (criteriaFlag) {
                        criteria.append(" AND ");
                    } else {
                        criteriaFlag = true;
                    }
                    criteria.append(columnName).append(" = ").append('?');
                }
                if (columnsFlag) {
                    columns.append(", ");
                } else {
                    columnsFlag = true;
                }
                columns.append(columnName);
            }
            current = current.getSuperclass();
        }
        if (!criteriaFlag) {
            throw new PkNotFoundException("Primary key not found in class ".concat(type.getName()).concat(", please use @Id to config"));
        }
        dml.setSql(String.format(GET, columns, tableName, criteria));
        dml.setFields(idFields);
    }

    private static class InstanceHolder {
        private static final GetDMLParser INSTANCE = new GetDMLParser();

        private InstanceHolder() {
        }
    }
}

