/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.transaction;

import cn.tenmg.sqltool.SqltoolFactory;
import cn.tenmg.sqltool.dsql.Sql;
import cn.tenmg.sqltool.dsql.utils.DsqlUtils;
import cn.tenmg.sqltool.exception.IllegalCallException;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.SQLException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.JdbcSql;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SqlExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSqlExecuter;
import cn.tenmg.sqltool.sql.executer.GetSqlExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSqlExecuter;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import cn.tenmg.sqltool.utils.SQLDialectUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomTransactionExecutor
implements Serializable {
    private static final long serialVersionUID = -1728127905781636407L;
    private static final Logger log = Logger.getLogger(CustomTransactionExecutor.class);
    private static ThreadLocal<Connection> currentConnection = new ThreadLocal();
    private static ThreadLocal<SQLDialect> currentSQLDialect = new ThreadLocal();
    private SqltoolFactory sqltoolFactory;
    private boolean showSql = true;
    private int defaultBatchSize = 500;

    public SqltoolFactory getSqltoolFactory() {
        return this.sqltoolFactory;
    }

    public void setSqltoolFactory(SqltoolFactory sqltoolFactory) {
        this.sqltoolFactory = sqltoolFactory;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public void beginTransaction(Map<String, String> options) {
        currentSQLDialect.set(SQLDialectUtils.getSQLDialect(options));
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            currentConnection.set(con);
        }
        catch (java.sql.SQLException e) {
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    public <T extends Serializable> int insert(T obj) throws java.sql.SQLException {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
        return JdbcUtils.execute(currentConnection.get(), dml.getSql(), params, ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int insert(List<T> rows) throws java.sql.SQLException {
        return JdbcUtils.insert(currentConnection.get(), this.showSql, rows);
    }

    public <T extends Serializable> int save(T obj) throws java.sql.SQLException {
        JdbcSql jdbcSql = currentSQLDialect.get().save(obj);
        return JdbcUtils.execute(currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int save(T obj, String ... hardFields) throws java.sql.SQLException {
        JdbcSql jdbcSql = currentSQLDialect.get().save(obj, hardFields);
        return JdbcUtils.execute(currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int save(List<T> rows) throws java.sql.SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.save(currentConnection.get(), this.showSql, rows, currentSQLDialect.get().save(((Serializable)rows.get(0)).getClass()));
    }

    public <T extends Serializable> int save(List<T> rows, String ... hardFields) throws java.sql.SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.save(currentConnection.get(), this.showSql, rows, currentSQLDialect.get().save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    public <T extends Serializable> int hardSave(T obj) throws java.sql.SQLException {
        JdbcSql jdbcSql = currentSQLDialect.get().hardSave(obj);
        return JdbcUtils.execute(currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
    }

    public <T extends Serializable> int hardSave(List<T> rows) throws java.sql.SQLException {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return JdbcUtils.hardSave(currentConnection.get(), currentSQLDialect.get(), this.showSql, rows);
    }

    public <T extends Serializable> T get(T obj) throws java.sql.SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)JdbcUtils.execute(currentConnection.get(), dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSqlExecuter(type), this.showSql));
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) throws java.sql.SQLException {
        return this.get(currentConnection.get(), this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) throws java.sql.SQLException {
        return this.get(currentConnection.get(), this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(T obj) throws java.sql.SQLException {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (List)JdbcUtils.execute(currentConnection.get(), dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new SelectSqlExecuter(type), this.showSql);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) throws java.sql.SQLException {
        return this.select(currentConnection.get(), this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) throws java.sql.SQLException {
        return this.select(currentConnection.get(), this.sqltoolFactory.parse(dsql, params), type);
    }

    public boolean execute(String dsql, Object ... params) {
        return this.execute(this.sqltoolFactory.parse(dsql, params));
    }

    public boolean execute(String dsql, Map<String, ?> params) {
        return this.execute(this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Object ... params) {
        return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Map<String, ?> params) {
        return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
    }

    public void rollback() {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        try {
            con.rollback();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
            currentConnection.remove();
        }
    }

    public void commit() {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        try {
            con.commit();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
            currentConnection.remove();
        }
    }

    private <T extends Serializable> T get(Connection con, Sql sql, Class<T> type) throws java.sql.SQLException {
        return (T)((Serializable)this.execute(con, sql, new GetSqlExecuter<T>(type)));
    }

    private <T extends Serializable> List<T> select(Connection con, Sql sql, Class<T> type) throws java.sql.SQLException {
        return (List)this.execute(con, sql, new SelectSqlExecuter<T>(type));
    }

    private boolean execute(Sql sql) {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
        PreparedStatement ps = null;
        boolean rs = false;
        try {
            String script = jdbcSql.getScript();
            List<Object> params = jdbcSql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, params);
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            rs = ps.execute();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return rs;
    }

    private int executeUpdate(Sql sql) {
        Connection con = CustomTransactionExecutor.getCurrentConnection();
        JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
        PreparedStatement ps = null;
        int count = 0;
        try {
            String script = jdbcSql.getScript();
            List<Object> params = jdbcSql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, params);
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(JdbcUtils.LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            count = ps.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return count;
    }

    private <T> T execute(Connection con, Sql sql, SqlExecuter<T> sqlExecuter) throws java.sql.SQLException {
        JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
        return JdbcUtils.execute(con, jdbcSql.getScript(), jdbcSql.getParams(), sqlExecuter, this.showSql);
    }

    private static Connection getCurrentConnection() {
        Connection con = currentConnection.get();
        if (con == null) {
            throw new IllegalCallException("You must call beginTransaction first before you call this method");
        }
        return con;
    }
}

