/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.MergeSql;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SqlExecuter;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String COMMA_SPACE = ", ";
    public static final String SPACE_AND_SPACE = " AND ";
    public static final String SPACE_EQ_SPACE = " = ";
    public static final char PARAM_MARK = '?';
    public static final char SINGLE_QUOTATION_MARK = '\'';

    private JdbcUtils() {
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Could not close JDBC Connection", (Throwable)ex);
                }
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                if (log.isErrorEnabled()) {
                    log.error("Unexpected exception on closing JDBC Connection", ex);
                }
                ex.printStackTrace();
            }
        }
    }

    public static void close(Statement stm) {
        if (stm != null) {
            try {
                stm.close();
            }
            catch (SQLException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Could not close JDBC Statement", (Throwable)ex);
                }
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                if (log.isErrorEnabled()) {
                    log.error("Unexpected exception on closing JDBC Statement", ex);
                }
                ex.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        block5: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Could not close JDBC ResultSet", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error("Unexpected exception on closing JDBC ResultSet", ex);
                }
            }
        }
    }

    public static <T> List<Object> getParams(T obj, List<Field> fields) {
        ArrayList<Object> params = new ArrayList<Object>();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            try {
                params.add(fields.get(i).get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
        return params;
    }

    public static void setParams(PreparedStatement ps, List<Object> params) throws SQLException {
        if (!CollectionUtils.isEmpty(params)) {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, params.get(i));
            }
        }
    }

    public static <T> void setParams(PreparedStatement ps, T obj, List<Field> fields) throws SQLException {
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fields.get(i).get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
    }

    public static <T> void setParams(PreparedStatement ps, List<FieldMeta> fieldMetas, T obj) throws SQLException {
        int size = fieldMetas.size();
        for (int i = 0; i < size; ++i) {
            try {
                ps.setObject(i + 1, fieldMetas.get(i).getField().get(obj));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DataAccessException(e);
            }
        }
    }

    public static <T> T execute(Connection con, String sql, List<Object> params, SqlExecuter<T> sqlExecuter, boolean showSql) throws SQLException {
        StringBuilder sb;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            JdbcUtils.setParams(ps, params);
            if (showSql) {
                sb = new StringBuilder();
                sb.append("Execute SQL: ").append(sql).append(LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info(sb.toString());
            }
            rs = sqlExecuter.execute(ps);
            sb = sqlExecuter.execute(ps, rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(ps);
        return (T)sb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> int insert(Connection con, boolean showSql, List<T> rows) throws SQLException {
        int n;
        Statement ps;
        block11: {
            ps = null;
            try {
                DML dml = InsertDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
                String sql = dml.getSql();
                List<Field> fields = dml.getFields();
                ps = con.prepareStatement(sql);
                if (showSql) {
                    log.info("Execute SQL: ".concat(sql));
                }
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                int[] counts = ps.executeBatch();
                con.commit();
                n = JdbcUtils.getCount(counts);
                if (ps == null) break block11;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> int save(Connection con, boolean showSql, List<T> rows, MergeSql mergeSql) throws SQLException {
        int n;
        Statement ps;
        block14: {
            ps = null;
            try {
                String sql = mergeSql.getScript();
                List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
                if (showSql) {
                    log.info("Execute SQL: ".concat(sql));
                }
                ps = con.prepareStatement(sql);
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                int[] counts = ps.executeBatch();
                con.commit();
                n = JdbcUtils.getCount(counts);
                if (ps == null) break block14;
            }
            catch (SQLException e) {
                try {
                    try {
                        con.rollback();
                        throw e;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    throw e;
                    catch (Exception e2) {
                        throw new DataAccessException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.clearBatch();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            try {
                ps.clearBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JdbcUtils.close(ps);
        return n;
    }

    public static <T> int hardSave(Connection con, SQLDialect dialect, boolean showSql, List<T> rows) throws SQLException {
        Statement ps = null;
        try {
            MergeSql mergeSql = dialect.hardSave(rows.get(0).getClass());
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (showSql) {
                log.info("Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
            }
            int[] counts = ps.executeBatch();
            con.commit();
            int n = JdbcUtils.getCount(counts);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
        }
    }

    public static final <T> void addBatch(PreparedStatement ps, List<FieldMeta> fieldMetas, T row) throws SQLException {
        JdbcUtils.setParams(ps, fieldMetas, row);
        ps.addBatch();
    }

    public static final <T> void addBatch(PreparedStatement ps, T row, List<Field> fields) throws SQLException {
        JdbcUtils.setParams(ps, row, fields);
        ps.addBatch();
    }

    private static int getCount(int[] counts) {
        int count = 0;
        if (counts != null) {
            for (int i = 0; i < counts.length; ++i) {
                count += counts[i];
            }
        }
        return count;
    }
}

