/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.factory;

import cn.tenmg.sqltool.SqltoolFactory;
import cn.tenmg.sqltool.config.ConfigLoader;
import cn.tenmg.sqltool.config.loader.XMLConfigLoader;
import cn.tenmg.sqltool.config.model.Dsql;
import cn.tenmg.sqltool.config.model.Sqltool;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.factory.AbstractSqltoolFactory;
import cn.tenmg.sqltool.utils.ClassUtils;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class XMLFileSqltoolFactory
extends AbstractSqltoolFactory
implements SqltoolFactory {
    private static final long serialVersionUID = 8125151681490092061L;
    private static final Logger log = Logger.getLogger(XMLFileSqltoolFactory.class);
    private static final ConfigLoader loader = XMLConfigLoader.getInstance();
    private String basePackages;
    private String suffix = ".dsql.xml";

    public String getBasePackages() {
        return this.basePackages;
    }

    public void setBasePackages(String basePackages) {
        this.basePackages = basePackages;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    private XMLFileSqltoolFactory() {
    }

    public static final XMLFileSqltoolFactory bind(String basePackages) {
        XMLFileSqltoolFactory factor = new XMLFileSqltoolFactory();
        factor.setBasePackages(basePackages);
        factor.init();
        return factor;
    }

    public static final XMLFileSqltoolFactory bind(String basePackages, String suffix) {
        XMLFileSqltoolFactory factor = new XMLFileSqltoolFactory();
        factor.setBasePackages(basePackages);
        factor.setSuffix(suffix);
        factor.init();
        return factor;
    }

    private void init() {
        if (StringUtils.isBlank(this.basePackages)) {
            log.warn((Object)"\u53c2\u6570basePackages\u6ca1\u6709\u914d\u7f6e");
        } else {
            String[] basePackages = this.basePackages.split(",");
            for (int i = 0; i < basePackages.length; ++i) {
                String basePackage = basePackages[i];
                try {
                    List<Object> files;
                    if (log.isInfoEnabled()) {
                        log.info((Object)"\u626b\u63cf\u5305\uff1a".concat(basePackage));
                    }
                    if (CollectionUtils.isEmpty(files = this.getDsqlFiles(basePackage.replaceAll("\\.", "/")))) {
                        log.warn((Object)"\u5305\uff1a".concat(basePackage).concat("\u6ca1\u6709\u627e\u5230\u540e\u7f00\u540d\u4e3a").concat(this.suffix).concat("\u7684\u6587\u4ef6"));
                        continue;
                    }
                    int size = files.size();
                    for (int j = 0; j < size; ++j) {
                        Sqltool sqltool;
                        String fileName;
                        Object file = files.get(j);
                        if (file instanceof File) {
                            File f = (File)file;
                            fileName = f.getName();
                            if (log.isInfoEnabled()) {
                                log.info((Object)"\u5f00\u59cb\u89e3\u6790".concat(fileName));
                            }
                            sqltool = loader.load(f);
                        } else {
                            fileName = (String)file;
                            if (log.isInfoEnabled()) {
                                log.info((Object)"\u5f00\u59cb\u89e3\u6790".concat(fileName));
                            }
                            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
                            InputStream is = classLoader.getResourceAsStream(fileName);
                            sqltool = loader.load(is);
                        }
                        List<Dsql> dsqls = sqltool.getDsql();
                        if (!CollectionUtils.isEmpty(dsqls)) {
                            for (Dsql dsql : dsqls) {
                                this.dsqls.put(dsql.getId(), dsql);
                            }
                        }
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)"\u5b8c\u6210\u89e3\u6790".concat(fileName));
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String msg = "\u626b\u63cf\u5305\uff1a".concat(basePackage).concat("\u52a0\u8f7dSQL\u6587\u4ef6\u5931\u8d25");
                    throw new IllegalConfigException(msg, e);
                }
            }
        }
    }

    private List<Object> getDsqlFiles(String dir) throws IOException, URISyntaxException {
        dir = dir.trim();
        ArrayList<Object> result = new ArrayList<Object>();
        Enumeration<URL> urls = ClassUtils.getDefaultClassLoader().getResources(dir);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().equals("jar")) {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (entry.isDirectory() || !name.endsWith(this.suffix)) continue;
                        result.add(name);
                    }
                    continue;
                }
                this.getDsqlFiles(new File(url.toURI()), result);
            }
        }
        return result;
    }

    private void getDsqlFiles(File parent, List<Object> files) {
        String fileName = parent.getName();
        if (parent.isDirectory()) {
            File[] listFiles = parent.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                File file = listFiles[i];
                fileName = file.getName();
                if (file.isDirectory()) {
                    this.getDsqlFiles(listFiles[i], files);
                    continue;
                }
                if (!fileName.endsWith(this.suffix)) continue;
                files.add(file);
            }
        } else if (fileName.endsWith(this.suffix)) {
            files.add(parent);
        }
    }
}

