/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sqltool.sql.dialect.AbstractSQLDialect;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PostgreSQLDialect
extends AbstractSQLDialect {
    private static final long serialVersionUID = 6822267270540270971L;
    private static final String UPDATE_SET_TEMPLATE = "${columnName} = ?";
    private static final String UPDATE_SET_IF_NOT_NULL_TEMPLATE = "${columnName} = COALESCE(?, ${columnName})";
    private static final String INSERT_IF_NOT_EXISTS = "INSERT INTO ${tableName} (${columns}) VALUES (${values}) ON CONFLICT(${ids}) DO NOTHING";
    private static final String SAVE = "INSERT INTO ${tableName} AS X(${columns}) VALUES (${values}) ON CONFLICT(${ids}) DO UPDATE SET ${sets}";
    private static final String IDS = "ids";
    private static final List<String> EXT_SQL_TEMPLATE_PARAM_NAMES = Arrays.asList("ids");
    private static final List<String> NEEDS_COMMA_PARAM_NAMES = Arrays.asList("columns", "values");
    private static final String SET_TEMPLATE = "${columnName} = EXCLUDED.${columnName}";
    private static final String SET_IF_NOT_NULL_TEMPLATE = "${columnName} = COALESCE(EXCLUDED.${columnName}, X.${columnName})";

    public static final PostgreSQLDialect getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private PostgreSQLDialect() {
    }

    @Override
    String getUpdateSetTemplate() {
        return UPDATE_SET_TEMPLATE;
    }

    @Override
    String getUpdateSetIfNotNullTemplate() {
        return UPDATE_SET_IF_NOT_NULL_TEMPLATE;
    }

    @Override
    List<String> getExtSQLTemplateParamNames() {
        return EXT_SQL_TEMPLATE_PARAM_NAMES;
    }

    @Override
    String getSaveSQLTemplate() {
        return SAVE;
    }

    @Override
    String getInsertIfNotExistsSQLTemplate() {
        return INSERT_IF_NOT_EXISTS;
    }

    @Override
    List<String> getNeedsCommaParamNames() {
        return NEEDS_COMMA_PARAM_NAMES;
    }

    @Override
    void handleColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams) {
        templateParams.get("columns").append(columnName);
        templateParams.get("values").append('?');
    }

    @Override
    void handleIdColumnWhenSave(String columnName, Map<String, StringBuilder> templateParams, boolean notFirst) {
        StringBuilder ids = templateParams.get(IDS);
        if (notFirst) {
            ids.append(", ");
        }
        ids.append(columnName);
    }

    @Override
    String getSetTemplate() {
        return SET_TEMPLATE;
    }

    @Override
    String getSetIfNotNullTemplate() {
        return SET_IF_NOT_NULL_TEMPLATE;
    }

    private static class InstanceHolder {
        private static final PostgreSQLDialect INSTANCE = new PostgreSQLDialect();

        private InstanceHolder() {
        }
    }
}

