/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.factory;

import cn.tenmg.sqltool.config.ConfigLoader;
import cn.tenmg.sqltool.config.loader.XMLConfigLoader;
import cn.tenmg.sqltool.config.model.Dsql;
import cn.tenmg.sqltool.config.model.Sqltool;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.factory.AbstractDSQLFactory;
import cn.tenmg.sqltool.utils.ClassUtils;
import cn.tenmg.sqltool.utils.CollectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class XMLFileDSQLFactory
extends AbstractDSQLFactory {
    private static final long serialVersionUID = 8125151681490092061L;
    private static final Logger log = Logger.getLogger(XMLFileDSQLFactory.class);
    private static final ConfigLoader loader = XMLConfigLoader.getInstance();
    private final Map<String, Dsql> dsqls = new HashMap<String, Dsql>();
    private String basePackages;
    private String suffix = ".dsql.xml";

    public String getBasePackages() {
        return this.basePackages;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public XMLFileDSQLFactory(String basePackages) {
        this.basePackages = basePackages;
        this.init();
    }

    public XMLFileDSQLFactory(String basePackages, String suffix) {
        this.basePackages = basePackages;
        this.suffix = suffix;
        this.init();
    }

    @Override
    Map<String, Dsql> getDsqls() {
        return this.dsqls;
    }

    private void init() {
        if (this.basePackages == null) {
            log.warn((Object)"The parameter basePackages is null");
        } else {
            String[] basePackages = this.basePackages.split(",");
            for (int i = 0; i < basePackages.length; ++i) {
                String basePackage = basePackages[i];
                String basePath = basePackage.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                String fileName = null;
                try {
                    List<Object> files;
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Scan package: ".concat(basePackage));
                    }
                    if (CollectionUtils.isEmpty(files = this.getDsqlFiles(basePath))) {
                        log.warn((Object)"The ".concat(this.suffix).concat(" file was not found in package : ").concat(basePackage));
                        continue;
                    }
                    int size = files.size();
                    for (int j = 0; j < size; ++j) {
                        Sqltool sqltool;
                        Object file = files.get(j);
                        if (file instanceof File) {
                            File f = (File)file;
                            fileName = basePath.concat(f.getName());
                            if (log.isInfoEnabled()) {
                                log.info((Object)"Start parsing: ".concat(fileName));
                            }
                            sqltool = loader.load(f);
                        } else {
                            String fullName = (String)file;
                            fileName = fullName.substring(basePath.lastIndexOf(basePath));
                            if (log.isInfoEnabled()) {
                                log.info((Object)"Start parsing: ".concat(fileName));
                            }
                            ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
                            InputStream is = classLoader.getResourceAsStream(fullName);
                            sqltool = loader.load(is);
                        }
                        List<Dsql> dsqls = sqltool.getDsql();
                        if (!CollectionUtils.isEmpty(dsqls)) {
                            for (Dsql dsql : dsqls) {
                                this.dsqls.put(dsql.getId(), dsql);
                            }
                        }
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)"Completed parse: ".concat(fileName));
                    }
                    continue;
                }
                catch (Exception e) {
                    String msg = fileName == null ? "Failed to scan package: " + basePackage : "Failed to load file: " + fileName + " in package: " + basePackage;
                    throw new IllegalConfigException(msg, e);
                }
            }
        }
    }

    private List<Object> getDsqlFiles(String dir) throws IOException, URISyntaxException {
        dir = dir.trim();
        ArrayList<Object> result = new ArrayList<Object>();
        Enumeration<URL> urls = ClassUtils.getDefaultClassLoader().getResources(dir);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().equals("jar")) {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (entry.isDirectory() || !name.endsWith(this.suffix)) continue;
                        result.add(name);
                    }
                    continue;
                }
                this.getDsqlFiles(new File(url.toURI()), result);
            }
        }
        return result;
    }

    private void getDsqlFiles(File parent, List<Object> files) {
        String fileName = parent.getName();
        if (parent.isDirectory()) {
            File[] listFiles = parent.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                File file = listFiles[i];
                fileName = file.getName();
                if (file.isDirectory()) {
                    this.getDsqlFiles(listFiles[i], files);
                    continue;
                }
                if (!fileName.endsWith(this.suffix)) continue;
                files.add(file);
            }
        } else if (fileName.endsWith(this.suffix)) {
            files.add(parent);
        }
    }
}

