/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.parser;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.PkNotFoundException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.AbstractDMLParser;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class UpdateDMLParser
extends AbstractDMLParser {
    private static final long serialVersionUID = 2569556565530119318L;
    private static final String UPDATE = "UPDATE %s SET %s WHERE %s";

    public static final UpdateDMLParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    protected <T> void parseDML(DML dml, Class<T> type, String tableName) {
        boolean setFlag = false;
        boolean criteriaFlag = false;
        StringBuilder set = new StringBuilder();
        StringBuilder criteria = new StringBuilder();
        ArrayList<Field> generalFields = new ArrayList<Field>();
        ArrayList<Field> idfields = new ArrayList<Field>();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        if (entityMeta == null) {
            Class<T> current = type;
            HashSet<String> fieldMap = new HashSet<String>();
            while (!Object.class.equals(current)) {
                Field[] declaredFields = current.getDeclaredFields();
                for (int i = 0; i < declaredFields.length; ++i) {
                    Field field = declaredFields[i];
                    String fieldName = field.getName();
                    if (fieldMap.contains(fieldName)) continue;
                    fieldMap.add(fieldName);
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    field.setAccessible(true);
                    String columnName = column.name();
                    if (StringUtils.isBlank(columnName)) {
                        columnName = StringUtils.camelToUnderline(fieldName, true);
                    }
                    if (field.getAnnotation(Id.class) == null) {
                        generalFields.add(field);
                        if (setFlag) {
                            set.append(", ");
                        } else {
                            setFlag = true;
                        }
                        set.append(columnName).append(" = ").append('?');
                        continue;
                    }
                    idfields.add(field);
                    if (criteriaFlag) {
                        criteria.append(" AND ");
                    } else {
                        criteriaFlag = true;
                    }
                    criteria.append(columnName).append(" = ").append(", ");
                }
                current = current.getSuperclass();
            }
        } else {
            List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
            int size = fieldMetas.size();
            for (int i = 0; i < size; ++i) {
                FieldMeta fieldMeta = fieldMetas.get(i);
                Field field = fieldMeta.getField();
                String columnName = fieldMeta.getColumnName();
                if (fieldMeta.isId()) {
                    idfields.add(field);
                    if (criteriaFlag) {
                        criteria.append(" AND ");
                    } else {
                        criteriaFlag = true;
                    }
                    criteria.append(columnName).append(" = ").append(", ");
                    continue;
                }
                generalFields.add(field);
                if (setFlag) {
                    set.append(", ");
                } else {
                    setFlag = true;
                }
                set.append(columnName).append(" = ").append('?');
            }
        }
        if (!criteriaFlag) {
            throw new PkNotFoundException("Primary key not found in class ".concat(type.getName()).concat(", please use @Id to config"));
        }
        dml.setSql(String.format(UPDATE, tableName, set, criteria));
        generalFields.addAll(idfields);
        dml.setFields(generalFields);
    }

    private static class InstanceHolder {
        private static final UpdateDMLParser INSTANCE = new UpdateDMLParser();

        private InstanceHolder() {
        }
    }
}

