/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dao;

import cn.tenmg.sqltool.Dao;
import cn.tenmg.sqltool.Transaction;
import cn.tenmg.sqltool.dsql.NamedSQL;
import cn.tenmg.sqltool.dsql.utils.DSQLUtils;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.SQLException;
import cn.tenmg.sqltool.exception.TransactionException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.MergeSQL;
import cn.tenmg.sqltool.sql.SQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.UpdateSQL;
import cn.tenmg.sqltool.sql.executer.ExecuteSQLExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSQLExecuter;
import cn.tenmg.sqltool.sql.executer.GetSQLExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSQLExecuter;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.sql.parser.UpdateDMLParser;
import cn.tenmg.sqltool.sql.utils.SQLUtils;
import cn.tenmg.sqltool.transaction.CurrentConnectionHolder;
import cn.tenmg.sqltool.transaction.TransactionExecutor;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public abstract class AbstractDao
implements Dao {
    private static final long serialVersionUID = -3116902261763223682L;
    private static final Logger log = Logger.getLogger(AbstractDao.class);

    abstract SQLDialect getSQLDialect(DataSource var1);

    abstract boolean isShowSql();

    abstract int getDefaultBatchSize();

    @Override
    public <T extends Serializable> int insert(T obj) {
        return this.insert(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int insert(DataSource dataSource, T obj) {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
        return this.execute(dataSource, dml.getSql(), params, ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int insert(List<T> rows) {
        return this.insert(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int insert(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            int count = JdbcUtils.insert(con, this.isShowSql(), rows);
            con.commit();
            int n = count;
            return n;
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    @Override
    public <T extends Serializable> void insertBatch(List<T> rows) {
        this.insertBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void insertBatch(DataSource dataSource, List<T> rows) {
        this.insertBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void insertBatch(List<T> rows, int batchSize) {
        this.insertBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void insertBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (!CollectionUtils.isEmpty(rows)) {
            DML dml = InsertDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
            this.executeBatch(dataSource, dml.getSql(), rows, dml.getFields(), batchSize);
        }
    }

    @Override
    public <T extends Serializable> int update(T obj) {
        return this.update(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, T obj) {
        SQL sql = this.getSQLDialect(dataSource).update(obj);
        return this.execute(dataSource, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int update(T obj, String ... hardFields) {
        return this.update(this.getDefaultDataSource(), obj, hardFields);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, T obj, String ... hardFields) {
        SQL sql = this.getSQLDialect(dataSource).update(obj, hardFields);
        return this.execute(dataSource, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int update(List<T> rows) {
        return this.update(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.update(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> int update(List<T> rows, String ... hardFields) {
        return this.update(this.getDefaultDataSource(), rows, hardFields);
    }

    @Override
    public <T extends Serializable> int update(DataSource dataSource, List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.update(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows) {
        this.updateBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows) {
        this.updateBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows, String ... hardFields) {
        this.updateBatch(rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows, String ... hardFields) {
        this.updateBatch(dataSource, rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows, int batchSize) {
        this.updateBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.updateBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> void updateBatch(List<T> rows, int batchSize, String ... hardFields) {
        this.updateBatch(this.getDefaultDataSource(), batchSize, rows, hardFields);
    }

    @Override
    public <T extends Serializable> void updateBatch(DataSource dataSource, List<T> rows, int batchSize, String ... hardFields) {
        this.updateBatch(dataSource, batchSize, rows, hardFields);
    }

    @Override
    public <T extends Serializable> int hardUpdate(T obj) {
        return this.hardUpdate(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int hardUpdate(DataSource dataSource, T obj) {
        DML dml = UpdateDMLParser.getInstance().parse(obj.getClass());
        List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
        return this.execute(dataSource, dml.getSql(), params, ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int hardUpdate(List<T> rows) {
        return this.hardUpdate(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int hardUpdate(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            int count = JdbcUtils.hardUpdate(con, this.isShowSql(), rows);
            con.commit();
            int n = count;
            return n;
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(List<T> rows) {
        this.hardUpdateBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(DataSource dataSource, List<T> rows) {
        this.hardUpdateBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(List<T> rows, int batchSize) {
        this.hardUpdateBatch(this.getDefaultDataSource(), rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardUpdateBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (!CollectionUtils.isEmpty(rows)) {
            DML dml = UpdateDMLParser.getInstance().parse(((Serializable)rows.get(0)).getClass());
            this.executeBatch(dataSource, dml.getSql(), rows, dml.getFields(), batchSize);
        }
    }

    @Override
    public <T extends Serializable> int save(T obj) {
        return this.save(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, T obj) {
        SQL sql = this.getSQLDialect(dataSource).save(obj);
        return this.execute(dataSource, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int save(T obj, String ... hardFields) {
        return this.save(this.getDefaultDataSource(), obj, hardFields);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, T obj, String ... hardFields) {
        SQL sql = this.getSQLDialect(dataSource).save(obj, hardFields);
        return this.execute(dataSource, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int save(List<T> rows) {
        return this.save(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.save(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> int save(List<T> rows, String ... hardFields) {
        return this.save(this.getDefaultDataSource(), rows, hardFields);
    }

    @Override
    public <T extends Serializable> int save(DataSource dataSource, List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        return AbstractDao.save(dataSource, this.isShowSql(), rows, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows) {
        this.saveBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows) {
        this.saveBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows, String ... hardFields) {
        this.saveBatch(rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows, String ... hardFields) {
        this.saveBatch(dataSource, rows, this.getDefaultBatchSize(), hardFields);
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows, int batchSize) {
        this.saveBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.saveBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass()));
    }

    @Override
    public <T extends Serializable> void saveBatch(List<T> rows, int batchSize, String ... hardFields) {
        this.saveBatch(this.getDefaultDataSource(), rows, batchSize, hardFields);
    }

    @Override
    public <T extends Serializable> void saveBatch(DataSource dataSource, List<T> rows, int batchSize, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.saveBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).save(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    @Override
    public <T extends Serializable> int hardSave(T obj) {
        return this.hardSave(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> int hardSave(DataSource dataSource, T obj) {
        SQL sql = this.getSQLDialect(dataSource).hardSave(obj);
        return this.execute(dataSource, sql.getScript(), sql.getParams(), ExecuteUpdateSQLExecuter.getInstance());
    }

    @Override
    public <T extends Serializable> int hardSave(List<T> rows) {
        return this.hardSave(this.getDefaultDataSource(), rows);
    }

    @Override
    public <T extends Serializable> int hardSave(DataSource dataSource, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return 0;
        }
        SQLDialect dialect = this.getSQLDialect(dataSource);
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            int count = JdbcUtils.hardSave(con, dialect, this.isShowSql(), rows);
            con.commit();
            int n = count;
            return n;
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(List<T> rows) {
        this.hardSaveBatch(rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(DataSource dataSource, List<T> rows) {
        this.hardSaveBatch(dataSource, rows, this.getDefaultBatchSize());
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(List<T> rows, int batchSize) {
        this.hardSaveBatch(this.getDefaultDataSource(), rows, batchSize);
    }

    @Override
    public <T extends Serializable> void hardSaveBatch(DataSource dataSource, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = this.getSQLDialect(dataSource);
        Connection con = null;
        Statement ps = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            MergeSQL mergeSql = dialect.hardSave(((Serializable)rows.get(0)).getClass());
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (this.isShowSql()) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (java.sql.SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
            JdbcUtils.close(con);
        }
    }

    @Override
    public <T extends Serializable> T get(T obj) {
        return this.get(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> T get(DataSource dataSource, T obj) {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)this.execute(dataSource, dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSQLExecuter(type)));
    }

    @Override
    public <T extends Serializable> T get(Class<T> type, String dsql, Object ... params) {
        return this.get(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> T get(DataSource dataSource, Class<T> type, String dsql, Object ... params) {
        return this.get(dataSource, this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, ?> params) {
        return this.get(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> T get(DataSource dataSource, Class<T> type, String dsql, Map<String, ?> params) {
        return this.get(dataSource, this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(T obj) {
        return this.select(this.getDefaultDataSource(), obj);
    }

    @Override
    public <T extends Serializable> List<T> select(DataSource dataSource, T obj) {
        Class<?> type = obj.getClass();
        SQL sql = SQLUtils.parseSelect(obj);
        return (List)this.execute(dataSource, sql.getScript(), sql.getParams(), new SelectSQLExecuter(type));
    }

    @Override
    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) {
        return this.select(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(DataSource dataSource, Class<T> type, String dsql, Object ... params) {
        return this.select(dataSource, this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, ?> params) {
        return this.select(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public <T extends Serializable> List<T> select(DataSource dataSource, Class<T> type, String dsql, Map<String, ?> params) {
        return this.select(dataSource, this.getDSQLFactory().parse(dsql, params), type);
    }

    @Override
    public boolean execute(String dsql, Object ... params) {
        return this.execute(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public boolean execute(DataSource dataSource, String dsql, Object ... params) {
        return this.execute(dataSource, this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public boolean execute(String dsql, Map<String, ?> params) {
        return this.execute(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public boolean execute(DataSource dataSource, String dsql, Map<String, ?> params) {
        return this.execute(dataSource, this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public int executeUpdate(String dsql, Object ... params) {
        return this.executeUpdate(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public int executeUpdate(DataSource dataSource, String dsql, Object ... params) {
        return this.executeUpdate(dataSource, this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public int executeUpdate(String dsql, Map<String, ?> params) {
        return this.executeUpdate(this.getDefaultDataSource(), this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public int executeUpdate(DataSource dataSource, String dsql, Map<String, ?> params) {
        return this.executeUpdate(dataSource, this.getDSQLFactory().parse(dsql, params));
    }

    @Override
    public void execute(Transaction transaction) {
        this.execute(this.getDefaultDataSource(), transaction);
    }

    @Override
    public void execute(DataSource dataSource, Transaction transaction) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            CurrentConnectionHolder.set(con);
            transaction.execute(new TransactionExecutor(this.isShowSql(), this.getDSQLFactory(), this.getSQLDialect(dataSource)));
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            if (e instanceof ClassNotFoundException) {
                throw new IllegalConfigException(e);
            }
            if (e instanceof java.sql.SQLException) {
                throw new SQLException(e);
            }
            throw new TransactionException(e);
        }
        finally {
            JdbcUtils.close(con);
            CurrentConnectionHolder.remove();
        }
    }

    private <T> T execute(DataSource dataSource, String sql, List<Object> params, SQLExecuter<T> sqlExecuter) {
        Connection con = null;
        T result = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(true);
            result = JdbcUtils.execute(con, sql, params, sqlExecuter, this.isShowSql());
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
        }
        return result;
    }

    private <T extends Serializable> void executeBatch(DataSource dataSource, String sql, List<T> rows, List<Field> fields, int batchSize) {
        Connection con = null;
        Statement ps = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            ps = con.prepareStatement(sql);
            if (this.isShowSql()) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (java.sql.SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
            JdbcUtils.close(con);
        }
    }

    private static <T> int update(DataSource dataSource, boolean showSql, List<T> rows, UpdateSQL updateSQL) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            int count = JdbcUtils.update(con, showSql, rows, updateSQL);
            con.commit();
            int n = count;
            return n;
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    private <T extends Serializable> void updateBatch(DataSource dataSource, int batchSize, List<T> rows, String ... hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.updateBatch(dataSource, rows, batchSize, this.getSQLDialect(dataSource).update(((Serializable)rows.get(0)).getClass(), hardFields));
    }

    private <T> void updateBatch(DataSource dataSource, List<T> rows, int batchSize, UpdateSQL updateSql) {
        Connection con = null;
        Statement ps = null;
        try {
            int size = rows.size();
            int current = 0;
            int times = (int)Math.ceil((double)size / (double)batchSize);
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            String sql = updateSql.getScript();
            List<Field> fields = updateSql.getFields();
            if (this.isShowSql()) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            while (current < times) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, rows.get(i), fields);
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
                ++current;
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (java.sql.SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
            JdbcUtils.close(con);
        }
    }

    private static <T> int save(DataSource dataSource, boolean showSql, List<T> rows, MergeSQL mergeSql) {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            int count = JdbcUtils.save(con, showSql, rows, mergeSql);
            con.commit();
            int n = count;
            return n;
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    private <T> void saveBatch(DataSource dataSource, List<T> rows, int batchSize, MergeSQL mergeSql) {
        Connection con = null;
        Statement ps = null;
        try {
            int size = rows.size();
            int current = 0;
            int times = (int)Math.ceil((double)size / (double)batchSize);
            con = dataSource.getConnection();
            con.setAutoCommit(false);
            String sql = mergeSql.getScript();
            List<FieldMeta> fieldMetas = mergeSql.getFieldMetas();
            if (this.isShowSql()) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            ps = con.prepareStatement(sql);
            while (current < times) {
                int end = (current + 1) * batchSize;
                int last = end < size ? end : size;
                for (int i = current * batchSize; i < last; ++i) {
                    JdbcUtils.addBatch((PreparedStatement)ps, fieldMetas, rows.get(i));
                }
                ps.executeBatch();
                con.commit();
                ps.clearBatch();
                ++current;
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            throw new SQLException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.clearBatch();
                }
                catch (java.sql.SQLException e) {
                    e.printStackTrace();
                }
                JdbcUtils.close(ps);
            }
            JdbcUtils.close(con);
        }
    }

    private <T extends Serializable> T get(DataSource dataSource, NamedSQL namedSQL, Class<T> type) {
        return (T)((Serializable)this.execute(dataSource, namedSQL, new GetSQLExecuter<T>(type)));
    }

    private <T> T execute(DataSource dataSource, NamedSQL namedSQL, SQLExecuter<T> sqlExecuter) {
        SQL sql = DSQLUtils.toSQL(namedSQL.getScript(), namedSQL.getParams());
        return this.execute(dataSource, sql.getScript(), sql.getParams(), sqlExecuter);
    }

    private <T extends Serializable> List<T> select(DataSource dataSource, NamedSQL namedSQL, Class<T> type) {
        return (List)this.execute(dataSource, namedSQL, new SelectSQLExecuter<T>(type));
    }

    private boolean execute(DataSource dataSource, NamedSQL namedSQL) {
        return this.execute(dataSource, namedSQL, ExecuteSQLExecuter.getInstance());
    }

    private int executeUpdate(DataSource dataSource, NamedSQL namedSQL) {
        return this.execute(dataSource, namedSQL, ExecuteUpdateSQLExecuter.getInstance());
    }
}

