/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dsql.converter;

import cn.tenmg.sqltool.config.model.Converter;
import cn.tenmg.sqltool.config.model.converter.ToNumber;
import cn.tenmg.sqltool.dsql.converter.ParamConverter;
import cn.tenmg.sqltool.exception.ConvertException;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.DecimalUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ToNumberParamConverter
implements ParamConverter {
    @Override
    public void convert(Converter converter, Map<String, Object> params) {
        List<ToNumber> toNumbers = converter.getToNumbers();
        if (CollectionUtils.isEmpty(toNumbers)) {
            return;
        }
        block4: for (ToNumber toNumber : toNumbers) {
            String paramsConfig = toNumber.getParams();
            String formatter = toNumber.getFormatter();
            if (!StringUtils.isNotBlank(paramsConfig)) continue;
            String[] paramsNames = paramsConfig.split(",");
            for (int i = 0; i < paramsNames.length; ++i) {
                String paramName2 = paramsNames[i].trim();
                if ("*".equals(paramName2)) {
                    Set<String> set = params.keySet();
                    for (String paramName2 : set) {
                        Object v = params.get(paramName2);
                        Number number = null;
                        if (v != null) {
                            try {
                                number = DecimalUtils.parse(v, formatter);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                                String msg = String.format("\u5c06\u53c2\u6570%s\uff1a%s\uff0c\u6309\u6a21\u677f\uff1a%s\uff0c\u8f6c\u6362\u4e3a\u6570\u5b57\u5bf9\u8c61\u5931\u8d25", paramName2, v.toString(), formatter);
                                throw new ConvertException(msg, e);
                            }
                        }
                        params.put(paramName2, number);
                    }
                    continue block4;
                }
                if (!params.containsKey(paramName2)) continue;
                Object v = params.get(paramName2);
                Number number = null;
                if (v != null) {
                    try {
                        number = DecimalUtils.parse(v, formatter);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        String msg = String.format("\u5c06\u53c2\u6570%s\uff1a%s\uff0c\u6309\u6a21\u677f\uff1a%s\uff0c\u8f6c\u6362\u4e3a\u6570\u5b57\u5bf9\u8c61\u5931\u8d25", paramName2, v.toString(), formatter);
                        throw new ConvertException(msg, e);
                    }
                }
                params.put(paramName2, number);
            }
        }
    }
}

