/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.factory;

import cn.tenmg.sqltool.DSQLFactory;
import cn.tenmg.sqltool.config.model.Converter;
import cn.tenmg.sqltool.config.model.Dsql;
import cn.tenmg.sqltool.config.model.Filter;
import cn.tenmg.sqltool.dsql.NamedSQL;
import cn.tenmg.sqltool.dsql.converter.ParamConverter;
import cn.tenmg.sqltool.dsql.filter.ParamFilter;
import cn.tenmg.sqltool.dsql.utils.DSQLUtils;
import cn.tenmg.sqltool.utils.CollectionUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class AbstractDSQLFactory
implements DSQLFactory {
    private static final long serialVersionUID = -169658678380590492L;

    abstract Map<String, Dsql> getDsqls();

    @Override
    public Dsql getDsql(String id) {
        return this.getDsqls().get(id);
    }

    @Override
    public String getScript(String id) {
        Dsql dsql = this.getDsql(id);
        if (dsql == null) {
            return null;
        }
        return dsql.getScript();
    }

    @Override
    public NamedSQL parse(String dsql, Object ... params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (params != null) {
            for (int i = 0; i < params.length - 1; ++i) {
                paramsMap.put(params[i].toString(), params[++i]);
            }
        }
        return this.parse(dsql, paramsMap);
    }

    @Override
    public NamedSQL parse(String dsql, Map<String, ?> params) {
        NamedSQL namedSQL = null;
        Dsql obj = this.getDsql(dsql);
        namedSQL = obj == null ? DSQLUtils.parse(dsql, new Object[]{params}) : this.parse(obj, params);
        return namedSQL;
    }

    protected NamedSQL parse(Dsql dsql, Map<String, ?> params) {
        Converter converter;
        Filter filter = dsql.getFilter();
        if (filter != null) {
            ServiceLoader<ParamFilter> loader = ServiceLoader.load(ParamFilter.class);
            Iterator<ParamFilter> it = loader.iterator();
            while (it.hasNext() && !CollectionUtils.isEmpty(params)) {
                ParamFilter paramFilter = it.next();
                paramFilter.doFilter(filter, params);
            }
        }
        if ((converter = dsql.getConverter()) != null) {
            HashMap<String, Object> paramaters = new HashMap<String, Object>();
            paramaters.putAll(params);
            ServiceLoader<ParamConverter> loader = ServiceLoader.load(ParamConverter.class);
            if (!CollectionUtils.isEmpty(params)) {
                for (ParamConverter paramConverter : loader) {
                    paramConverter.convert(converter, paramaters);
                }
            }
            params = paramaters;
        }
        return DSQLUtils.parse(dsql.getScript(), new Object[]{params});
    }
}

