/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.ColumnNotFoundException;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.exception.NoColumnForUpdateException;
import cn.tenmg.sqltool.exception.PkNotFoundException;
import cn.tenmg.sqltool.sql.MergeSQL;
import cn.tenmg.sqltool.sql.SQL;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.UpdateSQL;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.PlaceHolderUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSQLDialect
implements SQLDialect {
    private static final long serialVersionUID = -5454570237300496297L;
    private static final String UPDATE = "UPDATE ${tableName} SET ${sets} WHERE ${condition}";
    protected static final String TABLE_NAME = "tableName";
    protected static final String COLUMNS = "columns";
    protected static final String VALUES = "values";
    protected static final String SETS = "sets";
    protected static final String LEFT_COLUMN_NAME = "columnName";
    protected static final String RIGHT_COLUMN_NAME = "columnName";

    abstract String getUpdateSetTemplate();

    abstract String getUpdateSetIfNotNullTemplate();

    abstract List<String> getExtSQLTemplateParamNames();

    abstract String getSaveSQLTemplate();

    abstract String getInsertIfNotExistsSQLTemplate();

    abstract List<String> getNeedsCommaParamNames();

    abstract void handleColumnWhenSave(String var1, Map<String, StringBuilder> var2);

    abstract void handleIdColumnWhenSave(String var1, Map<String, StringBuilder> var2, boolean var3);

    abstract String getSetTemplate();

    abstract String getSetIfNotNullTemplate();

    @Override
    public <T> UpdateSQL update(Class<T> type) {
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean hasId = false;
        boolean hasGeneralColumn = false;
        StringBuilder sets = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        ArrayList<Field> generalFields = new ArrayList<Field>();
        ArrayList<Field> idFields = new ArrayList<Field>();
        try {
            if (entityMeta == null) {
                Class<T> current = type;
                HashSet<String> fieldSet = new HashSet<String>();
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                while (!Object.class.equals(current)) {
                    Field[] declaredFields = current.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        String fieldName = field.getName();
                        if (fieldSet.contains(fieldName)) continue;
                        fieldSet.add(fieldName);
                        Column column = field.getAnnotation(Column.class);
                        if (column == null) continue;
                        field.setAccessible(true);
                        String columnName = column.name();
                        if (StringUtils.isBlank(columnName)) {
                            columnName = StringUtils.camelToUnderline(fieldName, true);
                        }
                        FieldMeta fieldMeta = new FieldMeta(field, columnName);
                        if (field.getAnnotation(Id.class) == null) {
                            fieldMeta.setId(false);
                            generalFields.add(field);
                            if (hasGeneralColumn) {
                                sets.append(", ");
                            } else {
                                hasGeneralColumn = true;
                            }
                            sets.append(PlaceHolderUtils.replace(this.getUpdateSetIfNotNullTemplate(), "columnName", columnName));
                        } else {
                            fieldMeta.setId(true);
                            idFields.add(field);
                            if (hasId) {
                                condition.append(" AND ");
                            } else {
                                hasId = true;
                            }
                            condition.append(columnName).append(" = ").append('?');
                        }
                        fieldMetas.add(fieldMeta);
                    }
                    current = current.getSuperclass();
                }
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    Field field = fieldMeta.getField();
                    String columnName = fieldMeta.getColumnName();
                    if (fieldMeta.isId()) {
                        idFields.add(field);
                        if (hasId) {
                            condition.append(" AND ");
                        } else {
                            hasId = true;
                        }
                        condition.append(columnName).append(" = ").append('?');
                        continue;
                    }
                    generalFields.add(field);
                    if (hasGeneralColumn) {
                        sets.append(", ");
                    } else {
                        hasGeneralColumn = true;
                    }
                    sets.append(PlaceHolderUtils.replace(this.getUpdateSetIfNotNullTemplate(), "columnName", columnName));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        return this.updateSQL(type, hasId, hasGeneralColumn, entityMeta.getTableName(), sets, condition, generalFields, idFields);
    }

    @Override
    public <T> UpdateSQL update(Class<T> type, String ... hardFields) {
        HashSet<String> hardFieldSet = new HashSet<String>();
        for (int i = 0; i < hardFields.length; ++i) {
            hardFieldSet.add(hardFields[i]);
        }
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean hasId = false;
        boolean hasGeneralColumn = false;
        StringBuilder sets = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        ArrayList<Field> generalFields = new ArrayList<Field>();
        ArrayList<Field> idFields = new ArrayList<Field>();
        try {
            if (entityMeta == null) {
                Class<T> current = type;
                HashSet<String> fieldSet = new HashSet<String>();
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                while (!Object.class.equals(current)) {
                    Field[] declaredFields = current.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        String fieldName = field.getName();
                        if (fieldSet.contains(fieldName)) continue;
                        fieldSet.add(fieldName);
                        Column column = field.getAnnotation(Column.class);
                        if (column == null) continue;
                        field.setAccessible(true);
                        String columnName = column.name();
                        if (StringUtils.isBlank(columnName)) {
                            columnName = StringUtils.camelToUnderline(fieldName, true);
                        }
                        FieldMeta fieldMeta = new FieldMeta(field, columnName);
                        if (field.getAnnotation(Id.class) == null) {
                            fieldMeta.setId(false);
                            generalFields.add(field);
                            if (hasGeneralColumn) {
                                sets.append(", ");
                            } else {
                                hasGeneralColumn = true;
                            }
                            String updateSetTemplate = hardFieldSet.contains(field.getName()) ? this.getUpdateSetTemplate() : this.getUpdateSetIfNotNullTemplate();
                            sets.append(PlaceHolderUtils.replace(updateSetTemplate, "columnName", columnName));
                        } else {
                            fieldMeta.setId(true);
                            idFields.add(field);
                            if (hasId) {
                                condition.append(" AND ");
                            } else {
                                hasId = true;
                            }
                            condition.append(columnName).append(" = ").append('?');
                        }
                        fieldMetas.add(fieldMeta);
                    }
                    current = current.getSuperclass();
                }
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    Field field = fieldMeta.getField();
                    String columnName = fieldMeta.getColumnName();
                    if (fieldMeta.isId()) {
                        idFields.add(field);
                        if (hasId) {
                            condition.append(" AND ");
                        } else {
                            hasId = true;
                        }
                        condition.append(columnName).append(" = ").append('?');
                        continue;
                    }
                    generalFields.add(field);
                    if (hasGeneralColumn) {
                        sets.append(", ");
                    } else {
                        hasGeneralColumn = true;
                    }
                    String updateSetTemplate = hardFieldSet.contains(field.getName()) ? this.getUpdateSetTemplate() : this.getUpdateSetIfNotNullTemplate();
                    sets.append(PlaceHolderUtils.replace(updateSetTemplate, "columnName", columnName));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        return this.updateSQL(type, hasId, hasGeneralColumn, entityMeta.getTableName(), sets, condition, generalFields, idFields);
    }

    @Override
    public <T> MergeSQL save(Class<T> type) {
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean columnFound = false;
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnFound = this.parse(type, templateParams, fieldMetas);
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                StringBuilder sets = templateParams.get(SETS);
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    if (columnFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnFound = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSetIfNotNull(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnFound) {
            return this.mergeSql(entityMeta, templateParams);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    @Override
    public <T> MergeSQL save(Class<T> type, String ... hardFields) {
        HashSet<String> hardFieldSet = new HashSet<String>();
        for (int i = 0; i < hardFields.length; ++i) {
            hardFieldSet.add(hardFields[i]);
        }
        boolean columnFound = false;
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnFound = this.parse(type, templateParams, fieldMetas, hardFieldSet);
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                StringBuilder sets = templateParams.get(SETS);
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    if (columnFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnFound = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    if (hardFieldSet.contains(field.getName())) {
                        this.appendSet(sets, columnName);
                        continue;
                    }
                    this.appendSetIfNotNull(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnFound) {
            return this.mergeSql(entityMeta, templateParams);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    @Override
    public <T> MergeSQL hardSave(Class<T> type) {
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean columnFound = false;
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnFound = this.hardParse(type, templateParams, fieldMetas);
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                StringBuilder sets = templateParams.get(SETS);
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    if (columnFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnFound = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnFound) {
            return this.mergeSql(entityMeta, templateParams);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    @Override
    public <T> SQL update(T obj) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean hasId = false;
        boolean hasGeneralColumn = false;
        StringBuilder sets = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Object> conditionValues = new ArrayList<Object>();
        try {
            if (entityMeta == null) {
                Class<?> current = type;
                HashSet<String> fieldSet = new HashSet<String>();
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                while (!Object.class.equals(current)) {
                    Field[] declaredFields = current.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        String fieldName = field.getName();
                        if (fieldSet.contains(fieldName)) continue;
                        fieldSet.add(fieldName);
                        Column column = field.getAnnotation(Column.class);
                        if (column == null) continue;
                        field.setAccessible(true);
                        String columnName = column.name();
                        if (StringUtils.isBlank(columnName)) {
                            columnName = StringUtils.camelToUnderline(fieldName, true);
                        }
                        FieldMeta fieldMeta = new FieldMeta(field, columnName);
                        Object param = field.get(obj);
                        if (field.getAnnotation(Id.class) == null) {
                            fieldMeta.setId(false);
                            if (param != null) {
                                values.add(param);
                                if (hasGeneralColumn) {
                                    sets.append(", ");
                                } else {
                                    hasGeneralColumn = true;
                                }
                                sets.append(PlaceHolderUtils.replace(this.getUpdateSetTemplate(), "columnName", columnName));
                            }
                        } else {
                            fieldMeta.setId(true);
                            conditionValues.add(param);
                            if (hasId) {
                                condition.append(" AND ");
                            } else {
                                hasId = true;
                            }
                            condition.append(columnName).append(" = ").append('?');
                        }
                        fieldMetas.add(fieldMeta);
                    }
                    current = current.getSuperclass();
                }
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    Field field = fieldMeta.getField();
                    String columnName = fieldMeta.getColumnName();
                    Object param = field.get(obj);
                    if (fieldMeta.isId()) {
                        conditionValues.add(param);
                        if (hasId) {
                            condition.append(" AND ");
                        } else {
                            hasId = true;
                        }
                        condition.append(columnName).append(" = ").append('?');
                        continue;
                    }
                    if (param == null) continue;
                    values.add(param);
                    if (hasGeneralColumn) {
                        sets.append(", ");
                    } else {
                        hasGeneralColumn = true;
                    }
                    sets.append(PlaceHolderUtils.replace(this.getUpdateSetTemplate(), "columnName", columnName));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        return this.sql(obj, hasId, hasGeneralColumn, entityMeta.getTableName(), sets, condition, values, conditionValues);
    }

    @Override
    public <T> SQL update(T obj, String ... hardFields) {
        HashSet<String> hardFieldSet = new HashSet<String>();
        for (int i = 0; i < hardFields.length; ++i) {
            hardFieldSet.add(hardFields[i]);
        }
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean hasId = false;
        boolean hasGeneralColumn = false;
        StringBuilder sets = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Object> conditionValues = new ArrayList<Object>();
        try {
            if (entityMeta == null) {
                Class<?> current = type;
                HashSet<String> fieldSet = new HashSet<String>();
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                while (!Object.class.equals(current)) {
                    Field[] declaredFields = current.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        String fieldName = field.getName();
                        if (fieldSet.contains(fieldName)) continue;
                        fieldSet.add(fieldName);
                        Column column = field.getAnnotation(Column.class);
                        if (column == null) continue;
                        field.setAccessible(true);
                        String columnName = column.name();
                        if (StringUtils.isBlank(columnName)) {
                            columnName = StringUtils.camelToUnderline(fieldName, true);
                        }
                        FieldMeta fieldMeta = new FieldMeta(field, columnName);
                        Object param = field.get(obj);
                        if (field.getAnnotation(Id.class) == null) {
                            fieldMeta.setId(false);
                            if (param != null || hardFieldSet.contains(field.getName())) {
                                values.add(param);
                                if (hasGeneralColumn) {
                                    sets.append(", ");
                                } else {
                                    hasGeneralColumn = true;
                                }
                                sets.append(PlaceHolderUtils.replace(this.getUpdateSetTemplate(), "columnName", columnName));
                            }
                        } else {
                            fieldMeta.setId(true);
                            conditionValues.add(param);
                            if (hasId) {
                                condition.append(" AND ");
                            } else {
                                hasId = true;
                            }
                            condition.append(columnName).append(" = ").append('?');
                        }
                        fieldMetas.add(fieldMeta);
                    }
                    current = current.getSuperclass();
                }
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    Field field = fieldMeta.getField();
                    String columnName = fieldMeta.getColumnName();
                    Object param = field.get(obj);
                    if (fieldMeta.isId()) {
                        conditionValues.add(param);
                        if (hasId) {
                            condition.append(" AND ");
                        } else {
                            hasId = true;
                        }
                        condition.append(columnName).append(" = ").append('?');
                        continue;
                    }
                    if (param == null && !hardFieldSet.contains(field.getName())) continue;
                    values.add(param);
                    if (hasGeneralColumn) {
                        sets.append(", ");
                    } else {
                        hasGeneralColumn = true;
                    }
                    sets.append(PlaceHolderUtils.replace(this.getUpdateSetTemplate(), "columnName", columnName));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        return this.sql(obj, hasId, hasGeneralColumn, entityMeta.getTableName(), sets, condition, values, conditionValues);
    }

    @Override
    public <T> SQL save(T obj) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean columnFound = false;
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnFound = this.parse(obj, templateParams, params, fieldMetas);
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                StringBuilder sets = templateParams.get(SETS);
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Object param = fieldMeta.getField().get(obj);
                    if (param == null) continue;
                    params.add(param);
                    if (columnFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnFound = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnFound) {
            return this.sql(entityMeta.getTableName(), templateParams, params);
        }
        throw new ColumnNotFoundException(String.format("Not null column not found in class %s, please use @Column to config fields and make sure at lease one of them is not null", type.getName()));
    }

    @Override
    public <T> SQL save(T obj, String ... hardFields) {
        HashSet<String> hardFieldSet = new HashSet<String>();
        for (int i = 0; i < hardFields.length; ++i) {
            hardFieldSet.add(hardFields[i]);
        }
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean columnFound = false;
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnFound = this.parse(obj, templateParams, params, fieldMetas, hardFieldSet);
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                StringBuilder sets = templateParams.get(SETS);
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    Object param = field.get(obj);
                    if (param == null && !hardFieldSet.contains(field.getName())) continue;
                    params.add(param);
                    if (columnFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnFound = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnFound) {
            return this.sql(entityMeta.getTableName(), templateParams, params);
        }
        throw new ColumnNotFoundException(String.format("Not null or hard save column not found in class %s, please use @Column to config fields and make sure at lease one of them is not null or hard save", type.getName()));
    }

    @Override
    public <T> SQL hardSave(T obj) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        boolean columnFound = false;
        ArrayList<Object> params = new ArrayList<Object>();
        Map<String, StringBuilder> templateParams = this.getSQLTemplateParams();
        try {
            if (entityMeta == null) {
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnFound = this.hardParse(obj, templateParams, params, fieldMetas);
                entityMeta = new EntityMeta(EntityUtils.getTableName(type), fieldMetas);
                EntityUtils.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                StringBuilder sets = templateParams.get(SETS);
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    params.add(field.get(obj));
                    if (columnFound) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        columnFound = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (fieldMeta.isId()) {
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                        continue;
                    }
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnFound) {
            return this.sql(entityMeta.getTableName(), templateParams, params);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    private <T> UpdateSQL updateSQL(Class<T> type, boolean hasId, boolean hasGeneralColumn, String tableName, StringBuilder sets, StringBuilder condition, List<Field> generalFields, List<Field> idFields) {
        if (hasId) {
            if (hasGeneralColumn) {
                generalFields.addAll(idFields);
                return new UpdateSQL(PlaceHolderUtils.replace(UPDATE, TABLE_NAME, tableName, SETS, sets, "condition", condition), generalFields);
            }
            throw new NoColumnForUpdateException(String.format("There is only id column(s), but no general column found in class %s, please check your config", type.getName()));
        }
        throw new PkNotFoundException("Primary key not found in class ".concat(type.getName()).concat(", please use @Id to config"));
    }

    private <T> boolean parse(Class<T> type, Map<String, StringBuilder> templateParams, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<T> current = type;
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumnWhenSave(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSetIfNotNull(sets, columnName);
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean parse(Class<T> type, Map<String, StringBuilder> templateParams, List<FieldMeta> fieldMetas, Set<String> hardFieldSet) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<T> current = type;
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumnWhenSave(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    sets = templateParams.get(SETS);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    if (hardFieldSet.contains(field.getName())) {
                        this.appendSet(sets, columnName);
                    } else {
                        this.appendSetIfNotNull(sets, columnName);
                    }
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean hardParse(Class<T> type, Map<String, StringBuilder> templateParams, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<T> current = type;
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumnWhenSave(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean parse(T obj, Map<String, StringBuilder> templateParams, List<Object> params, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashSet<String> fieldSet = new HashSet<String>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldSet.contains(fieldName)) continue;
                fieldSet.add(fieldName);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                Object param = field.get(obj);
                if (param != null) {
                    params.add(param);
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                        if (setsFlag) {
                            sets.append(", ");
                        } else {
                            setsFlag = true;
                        }
                        this.appendSet(sets, columnName);
                    } else {
                        fieldMeta.setId(true);
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                    }
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean parse(T obj, Map<String, StringBuilder> templateParams, List<Object> params, List<FieldMeta> fieldMetas, Set<String> hardFieldSet) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                Object param = field.get(obj);
                if (param != null || hardFieldSet.contains(field.getName())) {
                    params.add(param);
                    if (flag) {
                        AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                    } else {
                        flag = true;
                    }
                    this.handleColumnWhenSave(columnName, templateParams);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                        if (setsFlag) {
                            sets.append(", ");
                        } else {
                            setsFlag = true;
                        }
                        this.appendSet(sets, columnName);
                    } else {
                        fieldMeta.setId(true);
                        this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                    }
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private <T> boolean hardParse(T obj, Map<String, StringBuilder> templateParams, List<Object> params, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        StringBuilder sets = templateParams.get(SETS);
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                params.add(field.get(obj));
                if (flag) {
                    AbstractSQLDialect.appendComma(templateParams, this.getNeedsCommaParamNames());
                } else {
                    flag = true;
                }
                this.handleColumnWhenSave(columnName, templateParams);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    this.appendSet(sets, columnName);
                } else {
                    fieldMeta.setId(true);
                    this.handleIdColumnWhenSave(columnName, templateParams, setsFlag);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private Map<String, StringBuilder> getSQLTemplateParams() {
        HashMap<String, StringBuilder> params = new HashMap<String, StringBuilder>();
        params.put(COLUMNS, new StringBuilder());
        params.put(VALUES, new StringBuilder());
        params.put(SETS, new StringBuilder());
        List<String> paramNames = this.getExtSQLTemplateParamNames();
        if (paramNames != null) {
            int size = paramNames.size();
            for (int i = 0; i < size; ++i) {
                params.put(paramNames.get(i), new StringBuilder());
            }
        }
        return params;
    }

    private void appendSet(StringBuilder sets, String columnName) {
        sets.append(PlaceHolderUtils.replace(this.getSetTemplate(), "columnName", columnName));
    }

    private void appendSetIfNotNull(StringBuilder sets, String columnName) {
        sets.append(PlaceHolderUtils.replace(this.getSetIfNotNullTemplate(), "columnName", columnName));
    }

    private static final void appendComma(Map<String, StringBuilder> params, List<String> paramNames) {
        int size = paramNames.size();
        for (int i = 0; i < size; ++i) {
            params.get(paramNames.get(i)).append(", ");
        }
    }

    private MergeSQL mergeSql(EntityMeta entityMeta, Map<String, StringBuilder> templateParams) {
        templateParams.put(TABLE_NAME, new StringBuilder(entityMeta.getTableName()));
        if (templateParams.get(SETS).length() > 0) {
            return new MergeSQL(PlaceHolderUtils.replace(this.getSaveSQLTemplate(), templateParams), entityMeta.getFieldMetas());
        }
        return new MergeSQL(PlaceHolderUtils.replace(this.getInsertIfNotExistsSQLTemplate(), templateParams), entityMeta.getFieldMetas());
    }

    private <T> SQL sql(T obj, boolean hasId, boolean hasGeneralColumn, String tableName, StringBuilder sets, StringBuilder condition, List<Object> values, List<Object> conditionValues) {
        if (hasId) {
            if (hasGeneralColumn) {
                values.addAll(conditionValues);
                return new SQL(PlaceHolderUtils.replace(UPDATE, TABLE_NAME, tableName, SETS, sets, "condition", condition), values);
            }
            throw new NoColumnForUpdateException(String.format("There is only id column(s), but no general column witch is not null found in object %s, please check your config and field value", obj.toString()));
        }
        throw new PkNotFoundException("Primary key not found in class ".concat(obj.getClass().getName()).concat(", please use @Id to config"));
    }

    private SQL sql(String tableName, Map<String, StringBuilder> templateParams, List<Object> params) {
        templateParams.put(TABLE_NAME, new StringBuilder(tableName));
        if (templateParams.get(SETS).length() > 0) {
            return new SQL(PlaceHolderUtils.replace(this.getSaveSQLTemplate(), templateParams), params);
        }
        return new SQL(PlaceHolderUtils.replace(this.getInsertIfNotExistsSQLTemplate(), templateParams), params);
    }
}

