/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.executer;

import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.SQLExecuter;
import cn.tenmg.sqltool.sql.utils.FieldUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SelectSQLExecuter<T>
implements SQLExecuter<List<T>> {
    protected Class<T> type;

    public SelectSQLExecuter() {
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public SelectSQLExecuter(Class<T> type) {
        this.type = type;
    }

    @Override
    public ResultSet execute(PreparedStatement ps) throws SQLException {
        return ps.executeQuery();
    }

    @Override
    public List<T> execute(PreparedStatement ps, ResultSet rs) throws SQLException {
        ArrayList<Object> rows = new ArrayList<Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        if (BigDecimal.class.isAssignableFrom(this.type)) {
            while (rs.next()) {
                rows.add(rs.getBigDecimal(1));
            }
        } else if (Number.class.isAssignableFrom(this.type)) {
            while (rs.next()) {
                Object obj = rs.getObject(1);
                if (obj == null) {
                    return null;
                }
                if (obj instanceof Number) {
                    if (Double.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).doubleValue();
                    } else if (Float.class.isAssignableFrom(this.type)) {
                        obj = Float.valueOf(((Number)obj).floatValue());
                    } else if (Integer.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).intValue();
                    } else if (Long.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).longValue();
                    } else if (Short.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).shortValue();
                    } else if (Byte.class.isAssignableFrom(this.type)) {
                        obj = ((Number)obj).byteValue();
                    }
                }
                rows.add(obj);
            }
        } else if (String.class.isAssignableFrom(this.type)) {
            while (rs.next()) {
                rows.add(rs.getString(1));
            }
        } else if (Date.class.isAssignableFrom(this.type)) {
            while (rs.next()) {
                rows.add(rs.getObject(1));
            }
        } else {
            HashMap<String, Integer> feildNames = new HashMap<String, Integer>();
            for (int i = 1; i <= columnCount; ++i) {
                String feildName = StringUtils.toCamelCase(rsmd.getColumnLabel(i), "_", false);
                feildNames.put(feildName, i);
            }
            HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
            Class<T> current = this.type;
            while (!Object.class.equals(current)) {
                FieldUtils.parseFields(feildNames, fieldMap, current.getDeclaredFields());
                current = current.getSuperclass();
            }
            while (rs.next()) {
                try {
                    T row = this.type.newInstance();
                    for (int i = 1; i <= columnCount; ++i) {
                        Field field = (Field)fieldMap.get(i);
                        if (field == null) continue;
                        field.set(row, JdbcUtils.getValue(rs, i, field.getType()));
                    }
                    rows.add(row);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new DataAccessException(e);
                }
            }
        }
        return rows;
    }
}

