/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.parser;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.ColumnNotFoundException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.sql.parser.AbstractDMLParser;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InsertDMLParser
extends AbstractDMLParser {
    private static final long serialVersionUID = -1072900553731732141L;
    private static final String INSERT = "INSERT INTO %s(%s) VALUES (%s)";

    public static final InsertDMLParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    protected <T> void parseDML(DML dml, Class<T> type, String tableName) {
        boolean flag = false;
        ArrayList<Field> fields = new ArrayList<Field>();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        if (entityMeta == null) {
            Class<T> current = type;
            HashSet<String> fieldSet = new HashSet<String>();
            ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
            while (!Object.class.equals(current)) {
                Field[] declaredFields = current.getDeclaredFields();
                for (int i = 0; i < declaredFields.length; ++i) {
                    Field field = declaredFields[i];
                    String fieldName = field.getName();
                    if (fieldSet.contains(fieldName)) continue;
                    fieldSet.add(fieldName);
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    field.setAccessible(true);
                    fields.add(field);
                    String columnName = column.name();
                    if (StringUtils.isBlank(columnName)) {
                        columnName = StringUtils.camelToUnderline(fieldName, true);
                    }
                    FieldMeta fieldMeta = new FieldMeta(field, columnName);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                    } else {
                        fieldMeta.setId(true);
                    }
                    if (flag) {
                        columns.append(", ");
                        values.append(", ");
                    } else {
                        flag = true;
                    }
                    columns.append(columnName);
                    values.append('?');
                    fieldMetas.add(fieldMeta);
                }
                current = current.getSuperclass();
            }
            EntityUtils.cacheEntityMeta(type, new EntityMeta(EntityUtils.getTableName(type), fieldMetas));
        } else {
            List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
            int size = fieldMetas.size();
            for (int i = 0; i < size; ++i) {
                FieldMeta fieldMeta = fieldMetas.get(i);
                fields.add(fieldMeta.getField());
                if (flag) {
                    columns.append(", ");
                    values.append(", ");
                } else {
                    flag = true;
                }
                columns.append(fieldMeta.getColumnName());
                values.append('?');
            }
        }
        if (!flag) {
            throw new ColumnNotFoundException("Column not found in class ".concat(type.getName()).concat(", please use @Column to config"));
        }
        dml.setSql(String.format(INSERT, tableName, columns, values));
        dml.setFields(fields);
    }

    private static class InstanceHolder {
        private static final InsertDMLParser INSTANCE = new InsertDMLParser();

        private InstanceHolder() {
        }
    }
}

