/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.utils;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.exception.PkNotFoundException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQL;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class SQLUtils {
    private static final String SELECT = "SELECT %s FROM %s%s";
    private static final String SPACE_WHERE_SPACE = " WHERE ";

    public static DML getCachedDML(String key) {
        return (DML)DMLCacheHolder.CACHE.get(key);
    }

    public static synchronized void cacheDML(String key, DML dml) {
        DMLCacheHolder.CACHE.put(key, dml);
    }

    public static <T> SQL parseSelect(T obj) {
        StringBuilder columns = new StringBuilder();
        StringBuilder criteria = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        boolean hasColumn = false;
        boolean hasWhere = false;
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = EntityUtils.getCachedEntityMeta(type);
        try {
            if (entityMeta == null) {
                Class<?> current = type;
                HashSet<String> fieldSet = new HashSet<String>();
                ArrayList<Field> fields = new ArrayList<Field>();
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                while (!Object.class.equals(current)) {
                    Field[] declaredFields = current.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        String fieldName = field.getName();
                        if (fieldSet.contains(fieldName)) continue;
                        fieldSet.add(fieldName);
                        Column column = field.getAnnotation(Column.class);
                        if (column == null) continue;
                        field.setAccessible(true);
                        fields.add(field);
                        String columnName = column.name();
                        if (StringUtils.isBlank(columnName)) {
                            columnName = StringUtils.camelToUnderline(fieldName, true);
                        }
                        FieldMeta fieldMeta = new FieldMeta(field, columnName);
                        if (field.getAnnotation(Id.class) == null) {
                            fieldMeta.setId(false);
                        } else {
                            fieldMeta.setId(true);
                        }
                        Object param = field.get(obj);
                        if (param != null) {
                            params.add(param);
                            if (hasWhere) {
                                criteria.append(" AND ");
                            } else {
                                hasWhere = true;
                                criteria.append(SPACE_WHERE_SPACE);
                            }
                            criteria.append(columnName).append(" = ").append('?');
                        }
                        if (hasColumn) {
                            columns.append(", ");
                        } else {
                            hasColumn = true;
                        }
                        columns.append(columnName);
                        fieldMetas.add(fieldMeta);
                    }
                    current = current.getSuperclass();
                }
                EntityUtils.cacheEntityMeta(type, new EntityMeta(EntityUtils.getTableName(type), fieldMetas));
            } else {
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Object param = fieldMeta.getField().get(obj);
                    if (param != null) {
                        params.add(param);
                        if (hasWhere) {
                            criteria.append(" AND ");
                        } else {
                            hasWhere = true;
                            criteria.append(SPACE_WHERE_SPACE);
                        }
                        criteria.append(columnName).append(" = ").append('?');
                    }
                    if (hasColumn) {
                        columns.append(", ");
                    } else {
                        hasColumn = true;
                    }
                    columns.append(columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (hasColumn) {
            return new SQL(String.format(SELECT, columns, EntityUtils.getTableName(type), criteria), params);
        }
        throw new PkNotFoundException("Column not found in class ".concat(type.getName()).concat(", please use @Column to config"));
    }

    private static final class DMLCacheHolder {
        private static volatile Map<String, DML> CACHE = new HashMap<String, DML>();

        private DMLCacheHolder() {
        }
    }
}

