/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class JSONUtils {
    public static final String toJSONString(Map<String, Object> params) {
        if (params != null) {
            StringBuilder sb = new StringBuilder("{");
            boolean flag = false;
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object value = entry.getValue();
                if (flag) {
                    sb.append(", ");
                } else {
                    flag = true;
                }
                JSONUtils.appendKey(sb, entry.getKey());
                JSONUtils.append(sb, value);
            }
            sb.append("}");
            return sb.toString();
        }
        return null;
    }

    public static final String toJSONString(Collection<Object> params) {
        if (params != null) {
            StringBuilder sb = new StringBuilder("[");
            boolean flag = false;
            for (Object value : params) {
                if (flag) {
                    sb.append(", ");
                } else {
                    flag = true;
                }
                JSONUtils.append(sb, value);
            }
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    public static final String toJSONString(Object ... params) {
        if (params != null) {
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < params.length; ++i) {
                Object value = params[i];
                if (i > 0) {
                    sb.append(", ");
                }
                JSONUtils.append(sb, value);
            }
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    private static final void appendKey(StringBuilder sb, String key) {
        sb.append("\"").append(key).append("\": ");
    }

    private static final void append(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof String) {
            JSONUtils.appendString(sb, (String)value);
        } else if (value instanceof Number || value instanceof Date || value instanceof Calendar || value instanceof Boolean || value instanceof BigDecimal) {
            sb.append(value.toString());
        } else if (value instanceof Collection) {
            sb.append(JSONUtils.toJSONString((Collection)value));
        } else if (value instanceof Object[]) {
            sb.append(JSONUtils.toJSONString((Object[])value));
        } else {
            JSONUtils.appendString(sb, value.toString());
        }
    }

    private static final void appendString(StringBuilder sb, String s) {
        sb.append("\"").append(s).append("\"");
    }
}

