/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import cn.tenmg.sqltool.exception.NosuitableSQLDialectExeption;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.dialect.MySQLDialect;
import cn.tenmg.sqltool.sql.dialect.OracleDialect;
import cn.tenmg.sqltool.sql.dialect.PostgreSQLDialect;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SQLDialectUtils {
    private static volatile Map<String, SQLDialect> DIALECTS = new HashMap<String, SQLDialect>();

    protected static synchronized void cacheSQLDialect(String url, SQLDialect dialect) {
        DIALECTS.put(url, dialect);
    }

    public static SQLDialect getSQLDialect(Map<String, String> options) {
        return SQLDialectUtils.getSQLDialect(options.get("url"));
    }

    public static SQLDialect getSQLDialect(Properties properties) {
        return SQLDialectUtils.getSQLDialect(properties.getProperty("url"));
    }

    private static SQLDialect getSQLDialect(String url) {
        SQLDialect dialect = null;
        if (DIALECTS.containsKey(url)) {
            dialect = DIALECTS.get(url);
        } else if (url != null) {
            if (url.contains("mysql")) {
                dialect = MySQLDialect.getInstance();
            } else if (url.contains("oracle")) {
                dialect = OracleDialect.getInstance();
            } else if (url.contains("postgresql")) {
                dialect = PostgreSQLDialect.getInstance();
            }
            SQLDialectUtils.cacheSQLDialect(url, dialect);
        }
        if (dialect == null) {
            throw new NosuitableSQLDialectExeption("There is no suitable SQL dialect provide for url: " + url);
        }
        return dialect;
    }
}

